/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.request;

import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.request.FutureTarget;
import io.intercom.com.bumptech.glide.request.Request;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.SizeReadyCallback;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.com.bumptech.glide.request.transition.Transition;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class RequestFutureTarget<R>
implements FutureTarget<R>,
RequestListener<R>,
Runnable {
    private static final Waiter DEFAULT_WAITER = new Waiter();
    private final Handler mainHandler;
    private final int width;
    private final int height;
    private final boolean assertBackgroundThread;
    private final Waiter waiter;
    @Nullable
    private R resource;
    @Nullable
    private Request request;
    private boolean isCancelled;
    private boolean resultReceived;
    private boolean loadFailed;
    @Nullable
    private GlideException exception;

    public RequestFutureTarget(Handler mainHandler, int width, int height) {
        this(mainHandler, width, height, true, DEFAULT_WAITER);
    }

    RequestFutureTarget(Handler mainHandler, int width, int height, boolean assertBackgroundThread, Waiter waiter) {
        this.mainHandler = mainHandler;
        this.width = width;
        this.height = height;
        this.assertBackgroundThread = assertBackgroundThread;
        this.waiter = waiter;
    }

    @Override
    public synchronized boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isDone()) {
            return false;
        }
        this.isCancelled = true;
        this.waiter.notifyAll(this);
        if (mayInterruptIfRunning) {
            this.clearOnMainThread();
        }
        return true;
    }

    @Override
    public synchronized boolean isCancelled() {
        return this.isCancelled;
    }

    @Override
    public synchronized boolean isDone() {
        return this.isCancelled || this.resultReceived || this.loadFailed;
    }

    @Override
    public R get() throws InterruptedException, ExecutionException {
        try {
            return this.doGet(null);
        }
        catch (TimeoutException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public R get(long time, @NonNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.doGet(timeUnit.toMillis(time));
    }

    @Override
    public void getSize(SizeReadyCallback cb) {
        cb.onSizeReady(this.width, this.height);
    }

    @Override
    public void removeCallback(SizeReadyCallback cb) {
    }

    @Override
    public void setRequest(@Nullable Request request) {
        this.request = request;
    }

    @Override
    @Nullable
    public Request getRequest() {
        return this.request;
    }

    @Override
    public void onLoadCleared(Drawable placeholder) {
    }

    @Override
    public void onLoadStarted(Drawable placeholder) {
    }

    @Override
    public synchronized void onLoadFailed(Drawable errorDrawable) {
    }

    @Override
    public synchronized void onResourceReady(R resource, Transition<? super R> transition) {
    }

    private synchronized R doGet(Long timeoutMillis) throws ExecutionException, InterruptedException, TimeoutException {
        if (this.assertBackgroundThread && !this.isDone()) {
            Util.assertBackgroundThread();
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (this.loadFailed) {
            throw new ExecutionException(this.exception);
        }
        if (this.resultReceived) {
            return this.resource;
        }
        if (timeoutMillis == null) {
            this.waiter.waitForTimeout(this, 0L);
        } else if (timeoutMillis > 0L) {
            this.waiter.waitForTimeout(this, timeoutMillis);
        }
        if (Thread.interrupted()) {
            throw new InterruptedException();
        }
        if (this.loadFailed) {
            throw new GlideExecutionException(this.exception);
        }
        if (this.isCancelled) {
            throw new CancellationException();
        }
        if (!this.resultReceived) {
            throw new TimeoutException();
        }
        return this.resource;
    }

    @Override
    public void run() {
        if (this.request != null) {
            this.request.clear();
            this.request = null;
        }
    }

    private void clearOnMainThread() {
        this.mainHandler.post((Runnable)this);
    }

    @Override
    public void onStart() {
    }

    @Override
    public void onStop() {
    }

    @Override
    public void onDestroy() {
    }

    @Override
    public synchronized boolean onLoadFailed(@Nullable GlideException e, Object model, Target<R> target, boolean isFirstResource) {
        this.loadFailed = true;
        this.exception = e;
        this.waiter.notifyAll(this);
        return false;
    }

    @Override
    public synchronized boolean onResourceReady(R resource, Object model, Target<R> target, DataSource dataSource, boolean isFirstResource) {
        this.resultReceived = true;
        this.resource = resource;
        this.waiter.notifyAll(this);
        return false;
    }

    private static class GlideExecutionException
    extends ExecutionException {
        private static final long serialVersionUID = 1L;
        private final GlideException cause;

        GlideExecutionException(GlideException cause) {
            this.cause = cause;
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        @Override
        public void printStackTrace(PrintStream s) {
            super.printStackTrace(s);
            s.print("Caused by: ");
            this.cause.printStackTrace(s);
        }

        @Override
        public void printStackTrace(PrintWriter s) {
            super.printStackTrace(s);
            s.print("Caused by: ");
            this.cause.printStackTrace(s);
        }
    }

    @VisibleForTesting
    static class Waiter {
        Waiter() {
        }

        void waitForTimeout(Object toWaitOn, long timeoutMillis) throws InterruptedException {
            toWaitOn.wait(timeoutMillis);
        }

        void notifyAll(Object toNotify) {
            toNotify.notifyAll();
        }
    }
}

