/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.models.AutoValue_Suggestion;
import io.intercom.android.sdk.utilities.NullSafety;

@AutoValue
public abstract class Suggestion
implements Parcelable {
    public static final Parcelable.Creator<Suggestion> CREATOR = new Parcelable.Creator<Suggestion>(){

        public Suggestion createFromParcel(Parcel in) {
            String preAction = in.readString();
            String text = in.readString();
            String uuid = in.readString();
            return Suggestion.create(preAction, text, uuid);
        }

        public Suggestion[] newArray(int size) {
            return new Suggestion[size];
        }
    };

    public static Suggestion create(String preAction, String text, String uuid) {
        return new AutoValue_Suggestion(preAction, text, uuid);
    }

    public abstract String getPreAction();

    public abstract String getText();

    public abstract String getUuid();

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.getPreAction());
        dest.writeString(this.getText());
        dest.writeString(this.getUuid());
    }

    public static final class Builder {
        @Nullable
        String pre_action;
        @Nullable
        String text;
        @Nullable
        String uuid;

        public Builder withPreAction(String preAction) {
            this.pre_action = preAction;
            return this;
        }

        public Builder withText(String text) {
            this.text = text;
            return this;
        }

        public Builder withUuid(String uuid) {
            this.uuid = uuid;
            return this;
        }

        public Suggestion build() {
            String preAction = NullSafety.valueOrEmpty(this.pre_action);
            String text = NullSafety.valueOrEmpty(this.text);
            String uuid = NullSafety.valueOrEmpty(this.uuid);
            return Suggestion.create(preAction, text, uuid);
        }
    }
}

