/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.content.res.Resources;
import android.support.annotation.Px;
import android.support.annotation.VisibleForTesting;
import android.support.constraint.ConstraintLayout;
import android.support.constraint.ConstraintSet;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.homescreen.BaseConversationCardViewHolder;
import io.intercom.android.sdk.homescreen.ConversationCard;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Participant;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.FontUtils;
import io.intercom.android.sdk.views.OfficeHoursTextView;
import io.intercom.com.bumptech.glide.RequestManager;
import java.util.List;

public class NewConversationCardViewHolder
extends BaseConversationCardViewHolder {
    private final FrameLayout avatarLayout;
    private final OfficeHoursTextView officeHoursView;
    private final ConstraintLayout constraintLayout;
    private final TextView seePreviousButton;
    @VisibleForTesting
    final TextView newConversationButton;
    private final Context context;
    private final Resources resources;
    @Px
    private int homeScreenWidth;

    NewConversationCardViewHolder(View itemView, Provider<AppConfig> appConfigProvider, HomeClickListener clickListener) {
        super(itemView, appConfigProvider, clickListener);
        this.newConversationButton = (TextView)itemView.findViewById(R.id.new_conversation_button);
        this.avatarLayout = (FrameLayout)itemView.findViewById(R.id.avatar_layout);
        LinearLayout rootLayout = (LinearLayout)itemView.findViewById(R.id.new_conversation_card_layout);
        this.officeHoursView = (OfficeHoursTextView)itemView.findViewById(R.id.office_hours);
        this.constraintLayout = (ConstraintLayout)itemView.findViewById(R.id.constraint_layout);
        this.seePreviousButton = (TextView)itemView.findViewById(R.id.see_previous);
        this.context = rootLayout.getContext();
        this.resources = this.context.getResources();
        this.homeScreenWidth = this.getHomeScreenWidth();
        this.newConversationButton.setOnClickListener(this.onNewConversationClicked);
        this.seePreviousButton.setOnClickListener(this.onSeePreviousClicked);
        this.applyCardBorderStyle((View)rootLayout);
        this.applyNewConversationButtonStyle(this.newConversationButton);
        this.applyAllConversationButtonStyle(this.seePreviousButton);
        this.showOrHideNewConversationButton(this.newConversationButton);
    }

    private void applyNewConversationButtonStyle(TextView newConversationButton) {
        FontUtils.setRobotoMediumTypeface(newConversationButton);
        this.updateButtonBackgroundColor(newConversationButton, ((AppConfig)this.appConfigProvider.get()).getPrimaryColor());
        boolean shouldRenderDarkText = ((AppConfig)this.appConfigProvider.get()).primaryColorRenderDarkText();
        int buttonTextColor = ColorUtils.whiteOrDarkColor(this.context, shouldRenderDarkText);
        newConversationButton.setTextColor(buttonTextColor);
        ColorUtils.updateLeftDrawableColor(newConversationButton, buttonTextColor);
    }

    public void bindTeamPresence(TeamPresence teamPresence, RequestManager requestManager, ConversationCard conversationCard) {
        if (teamPresence.isEmpty()) {
            this.officeHoursView.setVisibility(8);
            this.avatarLayout.setVisibility(8);
            this.seePreviousButton.setVisibility(8);
        } else {
            this.seePreviousButton.setVisibility(conversationCard.hasOlderConversations() ? 0 : 8);
            this.officeHoursView.setVisibility(0);
            this.avatarLayout.setVisibility(0);
            List<Participant> teammates = teamPresence.getActiveAdmins();
            if (!teammates.isEmpty()) {
                this.displayAvatars(teammates, requestManager);
                this.updateNewConversationButtonPosition(teammates.size());
            }
            this.updateOfficeHours(this.officeHoursView, teamPresence);
            this.updateOlderConversationUnreadState(this.seePreviousButton, conversationCard.hasOlderUnreadConversations());
        }
    }

    private void displayAvatars(List<Participant> teammates, RequestManager requestManager) {
        View view;
        ImageView avatarView;
        boolean shouldAddAvatar;
        int cardPadding = this.resources.getDimensionPixelOffset(R.dimen.intercom_conversation_card_padding);
        int cardMargin = this.resources.getDimensionPixelOffset(R.dimen.intercom_home_card_margin);
        int maxWidth = this.homeScreenWidth - 2 * cardPadding - 2 * cardMargin;
        LayoutInflater inflater = LayoutInflater.from((Context)this.context);
        for (int index = 0; index < teammates.size() && (shouldAddAvatar = this.updateLeftMarginForIndex(avatarView = (ImageView)(view = inflater.inflate(R.layout.intercom_view_conversation_card_avatar, (ViewGroup)this.avatarLayout, false)).findViewById(R.id.avatar_view), index, maxWidth)); ++index) {
            AvatarUtils.loadAvatarIntoView(teammates.get(index).getAvatar(), avatarView, (AppConfig)this.appConfigProvider.get(), requestManager);
            this.avatarLayout.addView((View)avatarView);
        }
    }

    private boolean updateLeftMarginForIndex(ImageView imageView, int index, @Px int maxWidth) {
        int avatarSize;
        FrameLayout.LayoutParams params = (FrameLayout.LayoutParams)imageView.getLayoutParams();
        Resources resources = imageView.getContext().getResources();
        int marginPx = resources.getDimensionPixelSize(R.dimen.intercom_conversation_card_avatar_margin);
        int expectedLeftMargin = index * marginPx;
        if (expectedLeftMargin + (avatarSize = resources.getDimensionPixelSize(R.dimen.intercom_conversation_card_avatar_size)) <= maxWidth) {
            params.leftMargin = index * marginPx;
            imageView.setLayoutParams((ViewGroup.LayoutParams)params);
            return true;
        }
        return false;
    }

    private void updateNewConversationButtonPosition(int numberOfTeammates) {
        ConstraintSet constraintSet = new ConstraintSet();
        constraintSet.clone(this.constraintLayout);
        int avatarId = R.id.avatar_layout;
        int conversationButtonId = R.id.new_conversation_button;
        int seePreviousId = R.id.see_previous;
        int buttonMargin = this.resources.getDimensionPixelSize(R.dimen.intercom_home_new_conversation_button_margin);
        if (numberOfTeammates <= 2) {
            constraintSet.connect(conversationButtonId, 1, avatarId, 2, buttonMargin);
            constraintSet.connect(conversationButtonId, 3, avatarId, 3, 0);
            constraintSet.connect(conversationButtonId, 4, avatarId, 4, 0);
            constraintSet.connect(seePreviousId, 3, avatarId, 4, buttonMargin);
        } else {
            constraintSet.connect(conversationButtonId, 3, avatarId, 4, buttonMargin);
            constraintSet.connect(seePreviousId, 1, conversationButtonId, 2, buttonMargin);
            constraintSet.connect(seePreviousId, 5, conversationButtonId, 5);
        }
        constraintSet.applyTo(this.constraintLayout);
    }

    @VisibleForTesting
    void updateOfficeHours(OfficeHoursTextView textView, TeamPresence teamPresence) {
        String officeHours = teamPresence.getOfficeHours();
        if (TextUtils.isEmpty((CharSequence)officeHours)) {
            textView.setText(teamPresence.getExpectedResponseDelay());
        } else {
            textView.setText(officeHours);
            int imageColor = ContextCompat.getColor((Context)this.context, (int)R.color.intercom_conversation_card_summary_text);
            textView.setOfficeHoursDrawable(imageColor);
        }
    }

    private int getHomeScreenWidth() {
        int homeScreenWidth = this.resources.getDisplayMetrics().widthPixels;
        boolean isTwoPane = this.resources.getBoolean(R.bool.intercom_is_two_pane);
        if (isTwoPane) {
            TypedValue typedValue = new TypedValue();
            this.resources.getValue(R.dimen.intercom_two_pane_inbox_percentage, typedValue, true);
            homeScreenWidth = (int)((float)homeScreenWidth * typedValue.getFloat());
        }
        return homeScreenWidth;
    }
}

