/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.carousel;

import android.view.View;
import io.intercom.android.sdk.carousel.CarouselListener;
import io.intercom.android.sdk.models.carousel.ScreenAction;

class ActionOnClickListener
implements View.OnClickListener {
    private final ScreenAction screenAction;
    private final CarouselListener listener;

    ActionOnClickListener(ScreenAction action, CarouselListener listener) {
        this.screenAction = action;
        this.listener = listener;
    }

    public void onClick(View view) {
        if (this.screenAction.isPermissionAction()) {
            this.listener.requestPermissions(this.screenAction);
            return;
        }
        switch (this.screenAction.getType()) {
            case "dismiss": {
                this.listener.trackActionButtonTappedStats();
                this.listener.dismissCarousel("from_cta");
                break;
            }
            case "link": {
                this.listener.trackActionButtonTappedStats();
                this.listener.openLink(this.screenAction.getUri());
                break;
            }
            case "start_chat": {
                this.listener.trackActionButtonTappedStats();
                this.listener.startChat();
                break;
            }
            case "skip": {
                this.listener.skipPermissionScreen();
                break;
            }
            default: {
                this.listener.selectNextScreen("from_cta");
            }
        }
    }
}

