/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.middleware;

import android.app.Activity;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Action;
import io.intercom.android.sdk.overlay.OverlayPresenter;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;

public class OverlayPresenterMiddleware
implements Store.Middleware<State> {
    private final Provider<OverlayPresenter> presenterProvider;

    public OverlayPresenterMiddleware(Provider<OverlayPresenter> presenterProvider) {
        this.presenterProvider = presenterProvider;
    }

    @Override
    public void dispatch(Store<State> store, Action<?> action, Store.NextDispatcher next) {
        OverlayState oldState = store.select(Selectors.OVERLAY);
        Activity oldPausedActivity = oldState.pausedHostActivity();
        Activity oldResumedActivity = oldState.resumedHostActivity();
        switch (action.type()) {
            case ACTIVITY_READY_FOR_VIEW_ATTACHMENT: {
                Activity resumedActivity = (Activity)action.value();
                if (resumedActivity == oldPausedActivity) break;
                this.removeOverlays(oldPausedActivity);
                break;
            }
            case ACTIVITY_PAUSED: {
                this.removeOverlays(oldPausedActivity);
                break;
            }
            case ACTIVITY_STOPPED: {
                Activity stoppedActivity = (Activity)action.value();
                if (stoppedActivity != oldPausedActivity) break;
                this.removeOverlays(oldPausedActivity);
                break;
            }
            case APP_ENTERED_BACKGROUND: {
                this.presenter().cancelAnimations();
                this.removeOverlays(oldPausedActivity);
                this.removeOverlays(oldResumedActivity);
                break;
            }
        }
        next.dispatch(action);
    }

    private void removeOverlays(@Nullable Activity activity) {
        if (activity != null) {
            this.presenter().removeOverlaysIfPresent(activity);
        }
    }

    private OverlayPresenter presenter() {
        return this.presenterProvider.get();
    }
}

