/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.support.v4.view.ViewCompat;
import android.support.v7.widget.RecyclerView;
import android.view.View;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.ColorUtils;

public abstract class BaseConversationCardViewHolder
extends RecyclerView.ViewHolder {
    final Provider<AppConfig> appConfigProvider;
    private HomeClickListener clickListener;
    View.OnClickListener onNewConversationClicked = new View.OnClickListener(){

        public void onClick(View view) {
            BaseConversationCardViewHolder.this.clickListener.onNewConversationClicked();
        }
    };
    View.OnClickListener onSeePreviousClicked = new View.OnClickListener(){

        public void onClick(View view) {
            BaseConversationCardViewHolder.this.clickListener.onSeePreviousClicked();
        }
    };

    BaseConversationCardViewHolder(View itemView, Provider<AppConfig> appConfigProvider, HomeClickListener clickListener) {
        super(itemView);
        this.appConfigProvider = appConfigProvider;
        this.clickListener = clickListener;
    }

    void applyCardBorderStyle(View cardView) {
        ColorUtils.updateInnerBorderColor(this.appConfigProvider.get(), cardView);
    }

    void applyAllConversationButtonStyle(TextView allConversationButton) {
        ColorUtils.setTextColorPrimaryOrBlack(allConversationButton, this.appConfigProvider.get());
    }

    void updateOlderConversationUnreadState(TextView seeAllButton, boolean hasOlderUnreadConversations) {
        if (hasOlderUnreadConversations) {
            Drawable unreadDot = ContextCompat.getDrawable((Context)seeAllButton.getContext(), (int)R.drawable.intercom_unread_dot);
            seeAllButton.setCompoundDrawablesWithIntrinsicBounds(unreadDot, null, null, null);
        } else {
            seeAllButton.setCompoundDrawablesWithIntrinsicBounds(null, null, null, null);
        }
    }

    void updateLeftDrawableColor(TextView view, @ColorInt int color2) {
        for (Drawable drawable2 : view.getCompoundDrawables()) {
            if (drawable2 == null) continue;
            drawable2.setColorFilter(color2, PorterDuff.Mode.SRC_IN);
        }
    }

    void updateButtonBackgroundColor(TextView view, @ColorInt int color2) {
        ViewCompat.setBackgroundTintList((View)view, (ColorStateList)ColorStateList.valueOf((int)color2));
    }

    void showOrHideNewConversationButton(TextView newConversationButton) {
        boolean hasInboundMessage = this.appConfigProvider.get().isInboundMessages();
        newConversationButton.setVisibility(hasInboundMessage ? 0 : 8);
    }
}

