/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.VisibleForTesting;
import android.webkit.CookieManager;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.conversation.JavascriptRunner;
import io.intercom.android.sdk.helpcenter.HelpCenterListener;
import io.intercom.android.sdk.helpcenter.HelpCenterWebViewClient;
import io.intercom.android.sdk.helpcenter.HelpCenterWebViewInterface;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.com.google.gson.Gson;
import java.util.Collections;
import java.util.Map;

public class HelpCenterWebViewPresenter {
    private final WebView webView;
    private final JavascriptRunner jsRunner;
    private final String helpCenterUrl;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final Provider<AppConfig> appConfigProvider;
    private final Store<State> store;
    private final Provider<Api> apiProvider;
    private final UserIdentity userIdentity;
    private final AppIdentity appIdentity;
    private final HelpCenterListener listener;
    private final CookieManager cookieManager;
    private final Map<String, String> headers = Collections.singletonMap("MobileClient", "AndroidIntercomWebView");
    @VisibleForTesting
    Intercom.Visibility hostLauncherVisibility;
    @VisibleForTesting
    Intercom.Visibility hostInAppsVisibility;

    public HelpCenterWebViewPresenter(WebView webView, JavascriptRunner jsRunner, String helpCenterUrl, Gson gson, MetricTracker metricTracker, Provider<AppConfig> appConfigProvider, Store<State> store, Provider<Api> apiProvider, UserIdentity userIdentity, AppIdentity appIdentity, CookieManager cookieManager, HelpCenterListener listener) {
        this.webView = webView;
        this.jsRunner = jsRunner;
        this.helpCenterUrl = helpCenterUrl;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.appConfigProvider = appConfigProvider;
        this.store = store;
        this.apiProvider = apiProvider;
        this.userIdentity = userIdentity;
        this.appIdentity = appIdentity;
        this.listener = listener;
        this.cookieManager = cookieManager;
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setUpWebView() {
        this.webView.setVerticalScrollBarEnabled(false);
        if (Build.VERSION.SDK_INT >= 21) {
            this.webView.setClipToOutline(true);
        }
        WebSettings webSettings = this.webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        HelpCenterWebViewInterface helpCenterWebViewInterface = new HelpCenterWebViewInterface(this.webView, this.gson, this.metricTracker, this.apiProvider.get());
        this.webView.addJavascriptInterface((Object)helpCenterWebViewInterface, "AndroidHost");
        this.webView.setWebViewClient((WebViewClient)new HelpCenterWebViewClient(Uri.parse((String)this.helpCenterUrl).getHost(), this.headers, this.listener));
    }

    public void loadBundle() {
        this.jsRunner.reset();
        this.setCookie();
        this.webView.loadUrl(this.helpCenterUrl, this.headers);
    }

    private void setCookie() {
        String key = "intercom-session-" + this.appIdentity.appId();
        String value = this.userIdentity.getEncryptedUserId();
        this.cookieManager.setCookie(this.helpCenterUrl, key + "=" + value);
    }

    public void setUpMessenger(io.intercom.android.sdk.experimental.Intercom intercomClient) {
        if (this.shouldForceShowMessengerInHelpCenter()) {
            this.storeHostVisibilitySettings();
            intercomClient.setLauncherVisibility(Intercom.VISIBLE);
            intercomClient.setInAppMessageVisibility(Intercom.VISIBLE);
        }
    }

    private void storeHostVisibilitySettings() {
        OverlayState overlayState = this.store.select(Selectors.OVERLAY);
        this.hostLauncherVisibility = overlayState.launcherVisibility();
        this.hostInAppsVisibility = overlayState.notificationVisibility();
    }

    public void resetMessengerToHostState(io.intercom.android.sdk.experimental.Intercom intercomClient) {
        if (this.shouldForceShowMessengerInHelpCenter()) {
            intercomClient.setLauncherVisibility(this.hostLauncherVisibility);
            intercomClient.setInAppMessageVisibility(this.hostInAppsVisibility);
        }
    }

    private boolean shouldForceShowMessengerInHelpCenter() {
        return !this.appConfigProvider.get().hasFeature("disable-force-show-help-center-messenger");
    }
}

