/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks.views;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.engine.GlideException;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.request.target.Target;

public class VideoPreviewView
extends RelativeLayout {
    private static final int PLAY_BUTTON_DIAMETER_DP = 48;
    private static final int PLAY_ARROW_OFFSET_DP = 3;
    private final ImageView thumbnailImageView;
    private final ImageView playButton;
    private final ProgressBar loadingSpinner;

    public VideoPreviewView(@NonNull Context context, Provider<AppConfig> appConfigProvider, StyleType style2) {
        super(context);
        BlockUtils.createLayoutParams((View)this, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)this);
        this.thumbnailImageView = this.getVideoImageView(context);
        this.playButton = this.getPlayButtonView(context);
        this.loadingSpinner = this.getLoadingSpinner();
        this.addView((View)this.thumbnailImageView);
        this.addView((View)this.playButton);
        this.addView((View)this.loadingSpinner);
        int color2 = appConfigProvider.get().getPrimaryColor();
        if (style2 == StyleType.POST) {
            color2 = ColorUtils.lightenColor(color2);
        }
        this.playButton.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
    }

    public ImageView getThumbnailImageView() {
        return this.thumbnailImageView;
    }

    public void displayThumbnail(String thumbnailUrl, RequestManager requestManager) {
        this.loadingSpinner.setVisibility(0);
        this.thumbnailImageView.setVisibility(4);
        requestManager.load(thumbnailUrl).apply(new RequestOptions().placeholder(R.drawable.intercom_video_thumbnail_fallback).error(R.drawable.intercom_video_thumbnail_fallback)).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).listener((RequestListener)new RequestListener<Drawable>(){

            public boolean onLoadFailed(@Nullable GlideException e, Object model, Target<Drawable> target, boolean isFirstResource) {
                VideoPreviewView.this.loadingSpinner.setVisibility(8);
                VideoPreviewView.this.thumbnailImageView.setVisibility(0);
                VideoPreviewView.this.updateThumbnailAspectRatio();
                VideoPreviewView.this.playButton.setVisibility(8);
                return false;
            }

            public boolean onResourceReady(Drawable drawable2, Object model, Target<Drawable> target, DataSource dataSource, boolean isFirstResource) {
                VideoPreviewView.this.loadingSpinner.setVisibility(8);
                VideoPreviewView.this.thumbnailImageView.setVisibility(0);
                VideoPreviewView.this.updateThumbnailAspectRatio();
                int colour = ContextCompat.getColor((Context)VideoPreviewView.this.thumbnailImageView.getContext(), (int)R.color.intercom_semi_transparent);
                VideoPreviewView.this.thumbnailImageView.setColorFilter(colour, PorterDuff.Mode.DARKEN);
                VideoPreviewView.this.playButton.setVisibility(0);
                return false;
            }
        }).into(this.thumbnailImageView);
    }

    private void updateThumbnailAspectRatio() {
        this.thumbnailImageView.getLayoutParams().height = this.thumbnailImageView.getWidth() * 3 / 4;
    }

    public void showFailedImage() {
        this.thumbnailImageView.post(new Runnable(){

            @Override
            public void run() {
                BackgroundUtils.setBackground((View)VideoPreviewView.this.thumbnailImageView, ContextCompat.getDrawable((Context)VideoPreviewView.this.getContext(), (int)R.drawable.intercom_video_thumbnail_fallback));
            }
        });
    }

    private ImageView getPlayButtonView(Context context) {
        int diameterPx = ScreenUtils.dpToPx((float)48.0f, (Context)context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(diameterPx, diameterPx);
        params.addRule(13);
        ImageView playButton = new ImageView(context);
        playButton.setLayoutParams((ViewGroup.LayoutParams)params);
        playButton.setScaleType(ImageView.ScaleType.CENTER);
        playButton.setImageResource(R.drawable.intercom_play_arrow);
        playButton.setPadding(ScreenUtils.dpToPx((float)3.0f, (Context)context), 0, 0, 0);
        playButton.setBackgroundResource(R.drawable.intercom_solid_circle);
        playButton.setVisibility(8);
        playButton.setId(R.id.intercom_video_thumbnail_play_button);
        return playButton;
    }

    private ImageView getVideoImageView(Context context) {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        ImageView videoImage = new ImageView(context);
        videoImage.setLayoutParams((ViewGroup.LayoutParams)params);
        videoImage.setAdjustViewBounds(true);
        videoImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
        videoImage.setId(R.id.intercom_video_thumbnail);
        return videoImage;
    }

    private ProgressBar getLoadingSpinner() {
        View view = VideoPreviewView.inflate((Context)this.getContext(), (int)R.layout.intercom_progress_bar, null);
        return (ProgressBar)view.findViewById(R.id.progressBar);
    }
}

