/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.inbox;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.content.res.ColorStateList;
import android.os.AsyncTask;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.design.widget.FloatingActionButton;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.DividerItemDecoration;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AnimationUtils;
import android.widget.ImageView;
import android.widget.ProgressBar;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.inbox.ConversationClickListener;
import io.intercom.android.sdk.inbox.InboxAdapter;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.android.sdk.utilities.WindowUtils;
import io.intercom.android.sdk.views.EndlessRecyclerScrollListener;
import io.intercom.android.sdk.views.EndlessScrollListener;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestManager;
import java.util.List;

public class InboxFragment
extends Fragment
implements View.OnClickListener,
ConversationClickListener,
EndlessScrollListener,
IntercomToolbar.Listener,
Store.Subscriber<InboxState> {
    private static final String ARG_IS_TWO_PANE = "is_two_pane";
    private static final int FADE_DURATION_MS = 150;
    private IntercomToolbar intercomToolbar;
    private View rootView;
    @VisibleForTesting
    RecyclerView inboxView;
    private IntercomErrorView inboxErrorView;
    private FloatingActionButton composerButton;
    private ProgressBar progressBar;
    private LinearLayoutManager layoutManager;
    private EndlessRecyclerScrollListener endlessRecyclerScrollListener;
    Listener listener = Listener.EMPTY;
    private InboxAdapter adapter;
    private Store<State> store;
    private Provider<AppConfig> appConfigProvider;
    private boolean isTwoPane = false;
    @Nullable
    private Store.Subscription subscription;
    private final Twig twig = LumberMill.getLogger();
    private WallpaperLoader wallpaperLoader;
    private RequestManager requestManager;

    public static InboxFragment newInstance(boolean isTwoPane) {
        InboxFragment fragment = new InboxFragment();
        Bundle args = new Bundle();
        args.putBoolean(ARG_IS_TWO_PANE, isTwoPane);
        fragment.setArguments(args);
        return fragment;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (Listener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement InboxFragment.Listener");
        }
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Injector injector = Injector.get();
        this.requestManager = Glide.with((Fragment)this);
        this.store = injector.getStore();
        this.appConfigProvider = injector.getAppConfigProvider();
        FragmentActivity activity = this.getActivity();
        TimeFormatter timeFormatter = new TimeFormatter((Context)activity, injector.getTimeProvider());
        this.adapter = new InboxAdapter(LayoutInflater.from((Context)activity), this, this.store, timeFormatter, this.appConfigProvider, injector.getUserIdentity(), this.requestManager);
        this.layoutManager = new LinearLayoutManager((Context)activity);
        this.endlessRecyclerScrollListener = new EndlessRecyclerScrollListener(this.layoutManager, this);
        Bundle args = this.getArguments();
        if (args != null) {
            this.isTwoPane = args.getBoolean(ARG_IS_TWO_PANE, false);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.twig.internal("inbox frag", "creating view for fragment");
        if (this.rootView == null) {
            this.rootView = inflater.inflate(R.layout.intercom_fragment_inbox, container, false);
            this.progressBar = (ProgressBar)this.rootView.findViewById(R.id.progress_bar);
            this.setUpRecyclerView();
            this.composerButton = (FloatingActionButton)this.rootView.findViewById(R.id.compose_action_button);
            this.composerButton.setOnClickListener((View.OnClickListener)this);
            this.inboxErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_inbox);
            this.inboxErrorView.setActionButtonTextColor(this.appConfigProvider.get().getPrimaryColor());
            this.inboxErrorView.setActionButtonClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    InboxFragment.this.store.dispatch(Actions.fetchInboxRequest());
                }
            });
            this.setUpToolbar();
            AsyncTask.THREAD_POOL_EXECUTOR.execute(new Runnable(){

                @Override
                public void run() {
                    InboxFragment.this.store.dispatch(Actions.fetchInboxRequest());
                }
            });
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
            this.setToolbarTitle();
            this.inboxView.scheduleLayoutAnimation();
        }
        return this.rootView;
    }

    private void setUpRecyclerView() {
        this.inboxView = (RecyclerView)this.rootView.findViewById(R.id.inbox_recycler_view);
        this.inboxView.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
        this.inboxView.addOnScrollListener((RecyclerView.OnScrollListener)this.endlessRecyclerScrollListener);
        this.inboxView.setAdapter((RecyclerView.Adapter)this.adapter);
        DividerItemDecoration dividerItemDecoration = new DividerItemDecoration(this.getContext(), 1);
        dividerItemDecoration.setDrawable(ContextCompat.getDrawable((Context)this.getContext(), (int)R.drawable.intercom_list_divider));
        this.inboxView.addItemDecoration((RecyclerView.ItemDecoration)dividerItemDecoration);
    }

    private void setUpToolbar() {
        this.intercomToolbar = (IntercomToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.updateToolbarSize();
        this.intercomToolbar.updateToolbarColors(this.appConfigProvider.get());
        this.intercomToolbar.setListener(this);
        this.intercomToolbar.setSubtitleVisibility(8);
        this.intercomToolbar.setInboxButtonVisibility(0);
        this.setToolbarTitle();
        View contentView = this.rootView.findViewById(R.id.intercom_inbox_content);
        contentView.setPadding(contentView.getPaddingLeft(), contentView.getPaddingTop() + WindowUtils.getStatusBarHeight(this.getResources()), contentView.getPaddingRight(), contentView.getPaddingBottom());
        this.wallpaperLoader = WallpaperLoader.create(this.getContext(), this.appConfigProvider, this.requestManager);
        this.intercomToolbar.loadWallpaper(this.wallpaperLoader);
        if (this.isTwoPane) {
            this.intercomToolbar.setCloseButtonVisibility(8);
        }
    }

    private boolean isInboundMessageEnabled() {
        return this.appConfigProvider.get().isInboundMessages();
    }

    public void onStart() {
        super.onStart();
        this.subscription = this.store.subscribeToChanges(Selectors.INBOX, this);
    }

    public void onResume() {
        this.store.dispatch(Actions.inboxOpened());
        if (!this.isTwoPane) {
            this.inboxView.setAlpha(1.0f);
        }
        this.setColorScheme();
        super.onResume();
    }

    public void onDestroyView() {
        this.intercomToolbar.closeWallpaperLoader(this.wallpaperLoader);
        super.onDestroyView();
    }

    private void setToolbarTitle() {
        String appName = this.appConfigProvider.get().getName();
        if (TextUtils.isEmpty((CharSequence)appName)) {
            this.intercomToolbar.setTitle(this.getString(R.string.intercom_conversations));
        } else {
            CharSequence title = Phrase.from(this.getContext(), R.string.intercom_conversations_with_app).put("name", appName).format();
            this.intercomToolbar.setTitle(title);
        }
        this.animateHeaderIn();
    }

    private void animateHeaderIn() {
        this.intercomToolbar.findViewById(R.id.intercom_toolbar_title).startAnimation(AnimationUtils.loadAnimation((Context)this.getContext(), (int)R.anim.intercom_profile_slide_in));
    }

    private void setColorScheme() {
        AppConfig appConfig = this.appConfigProvider.get();
        int primaryColor = appConfig.getPrimaryColor();
        int secondaryColor = appConfig.getSecondaryColor();
        this.composerButton.setBackgroundTintList(ColorStateList.valueOf((int)primaryColor));
        ColorUtils.setImageSrcColorWhiteOrDark((ImageView)this.composerButton, appConfig.primaryColorRenderDarkText());
        this.intercomToolbar.setBackgroundColor(secondaryColor);
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onStop();
    }

    public void onDetach() {
        super.onDetach();
        this.listener = Listener.EMPTY;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.compose_action_button) {
            if (this.isTwoPane) {
                this.listener.onComposerSelected();
            } else {
                this.fadeOutInbox((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                    public void onAnimationEnd(Animator animation) {
                        InboxFragment.this.listener.onComposerSelected();
                    }
                });
            }
        }
    }

    private void fadeOutInbox(Animator.AnimatorListener listener) {
        this.intercomToolbar.fadeOutTitle(150);
        this.inboxView.animate().alpha(0.0f).setDuration(150L).setListener(listener).start();
    }

    @Override
    public void onConversationClicked(int position) {
        final Conversation conversation = this.store.state().inboxState().conversations().get(position);
        if (this.isTwoPane) {
            this.listener.onConversationSelected(conversation);
        } else {
            this.fadeOutInbox((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    InboxFragment.this.listener.onConversationSelected(conversation);
                }
            });
        }
    }

    @Override
    public void onLoadMore() {
        InboxState inboxState = this.store.state().inboxState();
        List<Conversation> conversations = inboxState.conversations();
        if (inboxState.status() == InboxState.Status.LOADING || conversations.isEmpty()) {
            return;
        }
        long lastPartCreatedAt = conversations.get(conversations.size() - 1).getLastPart().getCreatedAt();
        this.store.dispatch(Actions.fetchInboxBeforeDateRequest(lastPartCreatedAt));
    }

    @Override
    public void setOverScrollColour() {
        ViewUtils.setOverScrollColour(this.inboxView, this.appConfigProvider.get().getPrimaryColor());
    }

    @Override
    public void onCloseClicked() {
        this.listener.onToolbarCloseClicked();
    }

    @Override
    public void onToolbarClicked() {
    }

    @Override
    public void onInboxClicked() {
        this.listener.onBackClicked();
    }

    @Override
    public void onStateChange(InboxState inboxState) {
        this.adapter.setInboxState(inboxState);
        this.adapter.notifyDataSetChanged();
        this.endlessRecyclerScrollListener.setMorePagesAvailable(inboxState.hasMorePages());
        if (!this.isAdded() || this.getView() == null) {
            return;
        }
        switch (inboxState.status()) {
            case INITIAL: {
                this.displayLoadingView();
                break;
            }
            case LOADING: {
                if (inboxState.conversations().isEmpty()) {
                    this.displayLoadingView();
                    break;
                }
                this.displayInbox();
                break;
            }
            case SUCCESS: {
                if (this.layoutManager.findFirstCompletelyVisibleItemPosition() == 0) {
                    this.layoutManager.scrollToPosition(0);
                }
                if (inboxState.conversations().isEmpty()) {
                    this.displayEmptyView();
                } else {
                    this.displayInbox();
                }
                this.listener.onConversationsLoaded(inboxState.conversations(), inboxState.status());
                break;
            }
            default: {
                this.displayErrorView();
            }
        }
    }

    private void displayLoadingView() {
        this.inboxErrorView.setVisibility(8);
        this.inboxView.setVisibility(8);
        this.composerButton.setVisibility(8);
        this.progressBar.setVisibility(0);
    }

    private void displayInbox() {
        this.inboxView.setVisibility(0);
        this.showComposerButtonIfEnabled();
        this.inboxErrorView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void displayEmptyView() {
        this.inboxErrorView.setTitle(R.string.intercom_no_conversations);
        CharSequence subtitle = Phrase.from(this.getContext(), R.string.intercom_empty_conversations).put("name", this.appConfigProvider.get().getName()).format();
        this.inboxErrorView.setSubtitle(subtitle);
        this.inboxErrorView.setActionButtonVisibility(8);
        this.inboxErrorView.setVisibility(0);
        this.showComposerButtonIfEnabled();
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
    }

    private void showComposerButtonIfEnabled() {
        this.composerButton.setVisibility(this.isInboundMessageEnabled() ? 0 : 8);
    }

    private void displayErrorView() {
        this.inboxErrorView.setTitle(R.string.intercom_inbox_error_state_title);
        this.inboxErrorView.setSubtitle(R.string.intercom_failed_to_load_conversation);
        this.inboxErrorView.setActionButtonText(R.string.intercom_retry);
        this.inboxErrorView.setActionButtonVisibility(0);
        this.inboxErrorView.setVisibility(0);
        this.inboxView.setVisibility(8);
        this.progressBar.setVisibility(8);
        this.composerButton.setVisibility(8);
    }

    public static interface Listener {
        public static final Listener EMPTY = new Listener(){

            @Override
            public void onConversationsLoaded(List<Conversation> conversations, InboxState.Status status) {
            }

            @Override
            public void onConversationSelected(Conversation conversation) {
            }

            @Override
            public void onComposerSelected() {
            }

            @Override
            public void onToolbarCloseClicked() {
            }

            @Override
            public void onBackClicked() {
            }
        };

        public void onConversationsLoaded(List<Conversation> var1, InboxState.Status var2);

        public void onConversationSelected(Conversation var1);

        public void onComposerSelected();

        public void onToolbarCloseClicked();

        public void onBackClicked();
    }
}

