/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.homescreen;

import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.BaseCallback;
import io.intercom.android.sdk.api.ErrorObject;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.IntercomLinkPresenter;
import io.intercom.android.sdk.homescreen.HomeCardAdapter;
import io.intercom.android.sdk.homescreen.HomeClickListener;
import io.intercom.android.sdk.homescreen.HomePresenter;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.imageloader.WallpaperLoader;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.HomeCardsResponse;
import io.intercom.android.sdk.models.TeamPresence;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.StoreUtils;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.utilities.WindowUtils;
import io.intercom.android.sdk.views.HomeToolbar;
import io.intercom.android.sdk.views.IntercomErrorView;
import io.intercom.android.sdk.views.IntercomLinkView;
import io.intercom.android.sdk.views.decoration.HomeItemDecoration;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;

public class HomeFragment
extends Fragment
implements IntercomLinkPresenter.IntercomLinkHost,
HomePresenter.Listener,
Store.Subscriber2<InboxState, TeamPresence> {
    private static final int OFFSCREEN_ITEM_CACHE = 4;
    private WallpaperLoader wallpaperLoader;
    private RequestManager requestManager;
    private HomeCardAdapter homeCardAdapter;
    private Store<State> store;
    private Provider<AppConfig> appConfigProvider;
    private Api api;
    private TimeProvider timeProvider;
    private Bus bus;
    private Gson gson;
    private MetricTracker metricTracker;
    private UserIdentity userIdentity;
    @Nullable
    private Store.Subscription subscription;
    private HomePresenter homePresenter;
    private HomeClickListener listener;
    private View rootView;
    private HomeToolbar toolbar;
    private View toolbarContent;
    private ViewGroup close;
    private View closeBackground;
    private View linkContainer;
    private IntercomErrorView intercomErrorView;
    private IntercomLinkView linkView;
    private RecyclerView recyclerView;
    private List<Object> cardList = new ArrayList<Object>();
    private int statusHeight;
    private int startLocationY;
    private final BaseCallback<HomeCardsResponse.Builder> apiCallback = new BaseCallback<HomeCardsResponse.Builder>(){

        @Override
        protected void onSuccess(HomeCardsResponse.Builder builder) {
            HomeCardsResponse homeCardsResponse = builder.build();
            HomeFragment.this.store.dispatch(Actions.fetchHomeCardsSuccess(homeCardsResponse));
            HomeFragment.this.homePresenter.updateConversationCard(homeCardsResponse.hasMoreConversations());
            HomeFragment.this.homePresenter.updateCards(homeCardsResponse.getCards());
            HomeFragment.this.toolbar.updateContent((AppConfig)HomeFragment.this.appConfigProvider.get(), HomeFragment.this.requestManager);
        }

        @Override
        protected void onError(ErrorObject errorDetails) {
            if (((AppConfig)HomeFragment.this.appConfigProvider.get()).isReceivedFromServer()) {
                HomeFragment.this.homePresenter.clearCards();
                HomeFragment.this.homePresenter.updateConversationCard(((State)HomeFragment.this.store.state()).hasConversations());
                HomeFragment.this.homePresenter.addErrorRow();
            } else {
                HomeFragment.this.homePresenter.clearCards();
                HomeFragment.this.intercomErrorView.setVisibility(0);
            }
            HomeFragment.this.toolbar.updateContent((AppConfig)HomeFragment.this.appConfigProvider.get(), HomeFragment.this.requestManager);
        }
    };

    public static HomeFragment newInstance() {
        return new HomeFragment();
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        try {
            this.listener = (HomeClickListener)context;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(context + " must implement ConversationCardClickListener");
        }
    }

    @Nullable
    public View onCreateView(@Nonnull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        if (this.rootView == null) {
            Injector injector = Injector.get();
            this.api = injector.getApi();
            this.appConfigProvider = injector.getAppConfigProvider();
            this.store = injector.getStore();
            this.timeProvider = injector.getTimeProvider();
            this.bus = injector.getBus();
            this.gson = injector.getGson();
            this.metricTracker = injector.getMetricTracker();
            this.userIdentity = injector.getUserIdentity();
            this.rootView = inflater.inflate(R.layout.intercom_fragment_home, container, false);
            this.statusHeight = WindowUtils.getStatusBarHeight(this.getResources());
            this.requestManager = Glide.with((Fragment)this);
            this.toolbar = (HomeToolbar)this.rootView.findViewById(R.id.intercom_toolbar);
            this.toolbarContent = this.rootView.findViewById(R.id.toolbar_content_container);
            this.recyclerView = (RecyclerView)this.rootView.findViewById(R.id.card_list);
            this.close = (ViewGroup)this.rootView.findViewById(R.id.intercom_home_close_container);
            this.closeBackground = this.rootView.findViewById(R.id.intercom_close_background);
            this.intercomErrorView = (IntercomErrorView)this.rootView.findViewById(R.id.error_layout_home_screen);
            this.setUpErrorScreen();
            this.setUpToolbar(this.appConfigProvider);
            this.setUpScrollListener();
            this.setUpCloseButton(this.appConfigProvider.get());
            this.setUpLinkView(this.appConfigProvider, this.api, this.rootView, injector.getAppIdentity().appId(), this.userIdentity.getIntercomId());
            this.setUpCardList(this.appConfigProvider, this.store, this.timeProvider, this.bus, this.gson, this.metricTracker, this.userIdentity);
        } else {
            ViewGroup parent = (ViewGroup)this.rootView.getParent();
            if (parent != null) {
                parent.removeView(this.rootView);
            }
            this.animateHeaderIn();
            this.recyclerView.scheduleLayoutAnimation();
        }
        return this.rootView;
    }

    public void onStart() {
        super.onStart();
        this.subscription = this.store.subscribeToChanges(Selectors.INBOX, Selectors.TEAM_PRESENCE, this);
    }

    public void onResume() {
        this.store.dispatch(Actions.homeOpened());
        super.onResume();
    }

    public void onStop() {
        StoreUtils.safeUnsubscribe(this.subscription);
        super.onStop();
    }

    public void onDestroyView() {
        this.toolbar.closeWallpaperLoader(this.wallpaperLoader);
        super.onDestroyView();
    }

    private void setUpScrollListener() {
        if (Build.VERSION.SDK_INT >= 23) {
            this.recyclerView.setOnScrollChangeListener(new View.OnScrollChangeListener(){

                public void onScrollChange(View v, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
                    HomeFragment.this.homePresenter.renderHeaderScrollChange(HomeFragment.this.recyclerView, HomeFragment.this.startLocationY, HomeFragment.this.closeBackground, HomeFragment.this.toolbarContent);
                }
            });
        } else {
            this.recyclerView.setOnScrollListener(new RecyclerView.OnScrollListener(){

                public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
                    super.onScrolled(recyclerView, dx, dy);
                    HomeFragment.this.homePresenter.renderHeaderScrollChange(recyclerView, HomeFragment.this.startLocationY, HomeFragment.this.closeBackground, HomeFragment.this.toolbarContent);
                }
            });
        }
    }

    private void setUpErrorScreen() {
        this.intercomErrorView.setActionButtonTextColor(ColorUtils.primaryOrDarkColor(this.intercomErrorView.getContext(), this.appConfigProvider.get()));
        this.intercomErrorView.setActionButtonClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.intercomErrorView.setVisibility(8);
                HomeFragment.this.loadHomeScreen();
            }
        });
    }

    private void setUpCloseButton(AppConfig appConfig) {
        ColorUtils.setImageColorWhiteOrBlack((ImageView)this.close.findViewById(R.id.intercom_toolbar_close), appConfig.secondaryColorRenderDarkText());
        this.close.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                HomeFragment.this.listener.onCloseClicked();
            }
        });
        this.close.setPadding(this.close.getPaddingLeft(), this.close.getPaddingTop() + this.statusHeight, this.close.getPaddingRight(), this.close.getPaddingBottom());
        ViewGroup.LayoutParams params = this.close.getLayoutParams();
        params.height += this.statusHeight;
        this.close.setLayoutParams(params);
    }

    private void setUpCardList(Provider<AppConfig> appConfigProvider, Store<State> store, TimeProvider timeProvider, Bus bus, Gson gson, MetricTracker metricTracker, UserIdentity userIdentity) {
        this.homePresenter = new HomePresenter(store, appConfigProvider, this.cardList, this);
        TimeFormatter timeFormatter = new TimeFormatter(this.getContext(), timeProvider);
        this.homeCardAdapter = new HomeCardAdapter(this.cardList, store, appConfigProvider, bus, gson, metricTracker, timeFormatter, this.requestManager, this.listener, userIdentity);
        this.recyclerView.setAdapter((RecyclerView.Adapter)this.homeCardAdapter);
        this.recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new HomeItemDecoration(this.getContext(), this.cardList));
        this.recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext()));
        this.recyclerView.setItemViewCacheSize(4);
        this.recyclerView.setItemAnimator(null);
        this.loadHomeScreen();
    }

    private void setUpLinkView(Provider<AppConfig> appConfigProvider, Api api, View rootView, String appId, String userId) {
        this.linkView = (IntercomLinkView)rootView.findViewById(R.id.intercom_link);
        this.linkContainer = rootView.findViewById(R.id.intercom_home_link_container);
        IntercomLinkPresenter linkPresenter = new IntercomLinkPresenter(this.linkView, appConfigProvider, api, "", appId, userId, true);
        linkPresenter.setup(this);
        if (appConfigProvider.get().shouldShowIntercomLink()) {
            this.linkContainer.setVisibility(0);
            this.recyclerView.setPadding(this.recyclerView.getPaddingLeft(), this.recyclerView.getPaddingTop(), this.recyclerView.getPaddingRight(), this.recyclerView.getPaddingBottom() + this.getResources().getDimensionPixelSize(R.dimen.intercom_link_height));
        } else {
            this.linkContainer.setVisibility(8);
        }
    }

    private void setUpToolbar(Provider<AppConfig> appConfigProvider) {
        int backgroundColor = appConfigProvider.get().getSecondaryColor();
        this.toolbar.setBackgroundColor(backgroundColor);
        this.wallpaperLoader = WallpaperLoader.create(this.getContext(), appConfigProvider, Glide.with((Fragment)this));
        this.toolbar.loadWallpaper(this.wallpaperLoader);
        this.toolbar.setBackgroundColor(backgroundColor);
        this.toolbar.updateToolbarColors(appConfigProvider.get());
        this.toolbarContent.setPadding(this.toolbarContent.getPaddingLeft(), this.toolbarContent.getPaddingTop() + this.statusHeight, this.toolbarContent.getPaddingRight(), this.toolbarContent.getPaddingBottom());
        this.toolbar.updateContent(appConfigProvider.get(), this.requestManager);
        this.animateHeaderIn();
        this.updateRecyclerViewPosition();
    }

    private void animateHeaderIn() {
        this.toolbar.animateIn(this.toolbarContent);
    }

    private void updateRecyclerViewPosition() {
        this.startLocationY = this.recyclerView.getPaddingTop() + this.toolbar.getContentHeight(this.toolbarContent) - this.getResources().getDimensionPixelSize(R.dimen.intercom_home_screen_overlap);
        this.recyclerView.setPadding(this.recyclerView.getPaddingLeft(), this.startLocationY, this.recyclerView.getPaddingRight(), this.recyclerView.getPaddingBottom());
    }

    private void loadHomeScreen() {
        this.homePresenter.clearCards();
        this.homePresenter.addLoadingCards();
        this.api.fetchHomeCards(this.apiCallback);
    }

    @Override
    public void addBottomPadding(int extraBottomPadding) {
    }

    @Override
    public boolean isAtBottom() {
        return false;
    }

    @Override
    public void notifyItemChanged(int position) {
        this.homeCardAdapter.notifyItemChanged(position);
    }

    @Override
    public void onStateChange(InboxState inboxState, TeamPresence teamPresence) {
        if (inboxState.status().equals((Object)InboxState.Status.SUCCESS) && !teamPresence.isEmpty()) {
            this.homePresenter.updateConversationCard();
        }
    }

    public void reload() {
        this.loadHomeScreen();
    }
}

