/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.Location;
import io.intercom.android.sdk.models.SocialAccount;
import io.intercom.android.sdk.utilities.NullSafety;
import java.util.List;

public class LastParticipatingAdmin
implements Parcelable {
    private static final String TWITTER = "twitter";
    private static final String LINKED_IN = "linkedin";
    private final long lastActiveAt;
    private final String firstName;
    private final String intro;
    private final String jobTitle;
    private final Location location;
    private final Avatar avatar;
    private final SocialAccount twitter;
    private final SocialAccount linkedIn;
    private final boolean isActive;
    public static final Parcelable.Creator<LastParticipatingAdmin> CREATOR = new Parcelable.Creator<LastParticipatingAdmin>(){

        public LastParticipatingAdmin createFromParcel(Parcel in) {
            return new LastParticipatingAdmin(in);
        }

        public LastParticipatingAdmin[] newArray(int size) {
            return new LastParticipatingAdmin[size];
        }
    };
    public static final LastParticipatingAdmin NULL = new LastParticipatingAdmin(new Builder());
    public static final LastParticipatingAdmin NONE = new LastParticipatingAdmin(new Builder());

    public LastParticipatingAdmin(Builder builder) {
        this.avatar = builder.avatar == null ? new Avatar.Builder().build() : builder.avatar.build();
        this.firstName = NullSafety.valueOrEmpty(builder.first_name);
        this.intro = NullSafety.valueOrEmpty(builder.intro);
        this.jobTitle = NullSafety.valueOrEmpty(builder.job_title);
        this.location = builder.location == null ? new Location.Builder().build() : builder.location.build();
        this.lastActiveAt = builder.last_active_at;
        this.isActive = builder.is_active;
        SocialAccount tmpTwitter = SocialAccount.NULL;
        SocialAccount tmpLinkedIn = SocialAccount.NULL;
        if (builder.social_accounts != null) {
            for (SocialAccount.Builder socialBuilder : builder.social_accounts) {
                SocialAccount socialAccount = socialBuilder.build();
                if (TWITTER.equals(socialAccount.getProvider())) {
                    tmpTwitter = socialAccount;
                    continue;
                }
                if (!LINKED_IN.equals(socialAccount.getProvider())) continue;
                tmpLinkedIn = socialAccount;
            }
        }
        this.twitter = tmpTwitter;
        this.linkedIn = tmpLinkedIn;
    }

    public long getLastActiveAt() {
        return this.lastActiveAt;
    }

    public Avatar getAvatar() {
        return this.avatar;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getIntro() {
        return this.intro;
    }

    public String getJobTitle() {
        return this.jobTitle;
    }

    public Location getLocation() {
        return this.location;
    }

    public SocialAccount getTwitter() {
        return this.twitter;
    }

    public SocialAccount getLinkedIn() {
        return this.linkedIn;
    }

    public boolean isActive() {
        return this.isActive;
    }

    LastParticipatingAdmin(Parcel in) {
        this.lastActiveAt = in.readLong();
        this.isActive = in.readByte() != 0;
        this.avatar = (Avatar)in.readValue(Avatar.class.getClassLoader());
        this.firstName = in.readString();
        this.intro = in.readString();
        this.jobTitle = in.readString();
        this.location = (Location)in.readValue(Location.class.getClassLoader());
        this.twitter = (SocialAccount)in.readValue(SocialAccount.class.getClassLoader());
        this.linkedIn = (SocialAccount)in.readValue(SocialAccount.class.getClassLoader());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.lastActiveAt);
        dest.writeByte((byte)(this.isActive ? 1 : 0));
        dest.writeValue((Object)this.avatar);
        dest.writeString(this.firstName);
        dest.writeString(this.intro);
        dest.writeString(this.jobTitle);
        dest.writeValue((Object)this.location);
        dest.writeValue((Object)this.twitter);
        dest.writeValue((Object)this.linkedIn);
    }

    public static boolean isNull(@Nullable LastParticipatingAdmin admin) {
        return admin != NONE && (NULL.equals(admin) || admin == null);
    }

    public static final class Builder {
        long last_active_at;
        @Nullable
        Avatar.Builder avatar;
        @Nullable
        String first_name;
        @Nullable
        String intro;
        @Nullable
        String job_title;
        @Nullable
        Location.Builder location;
        @Nullable
        List<SocialAccount.Builder> social_accounts;
        boolean is_active;

        public LastParticipatingAdmin build() {
            return new LastParticipatingAdmin(this);
        }

        @VisibleForTesting
        public Builder withJobTitle(String job_title) {
            this.job_title = job_title;
            return this;
        }

        @VisibleForTesting
        public Builder withIntro(String intro) {
            this.intro = intro;
            return this;
        }

        @VisibleForTesting
        public Builder withFirstName(String firstName) {
            this.first_name = firstName;
            return this;
        }
    }
}

