/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.resource.gif;

import android.util.Log;
import io.intercom.com.bumptech.glide.load.ImageHeaderParser;
import io.intercom.com.bumptech.glide.load.ImageHeaderParserUtils;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.ResourceDecoder;
import io.intercom.com.bumptech.glide.load.engine.Resource;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.ArrayPool;
import io.intercom.com.bumptech.glide.load.resource.gif.GifDrawable;
import io.intercom.com.bumptech.glide.load.resource.gif.GifOptions;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.List;

public class StreamGifDecoder
implements ResourceDecoder<InputStream, GifDrawable> {
    private static final String TAG = "StreamGifDecoder";
    private final List<ImageHeaderParser> parsers;
    private final ResourceDecoder<ByteBuffer, GifDrawable> byteBufferDecoder;
    private final ArrayPool byteArrayPool;

    public StreamGifDecoder(List<ImageHeaderParser> parsers, ResourceDecoder<ByteBuffer, GifDrawable> byteBufferDecoder, ArrayPool byteArrayPool) {
        this.parsers = parsers;
        this.byteBufferDecoder = byteBufferDecoder;
        this.byteArrayPool = byteArrayPool;
    }

    @Override
    public boolean handles(InputStream source, Options options) throws IOException {
        return options.get(GifOptions.DISABLE_ANIMATION) == false && ImageHeaderParserUtils.getType(this.parsers, source, this.byteArrayPool) == ImageHeaderParser.ImageType.GIF;
    }

    @Override
    public Resource<GifDrawable> decode(InputStream source, int width, int height, Options options) throws IOException {
        byte[] data = StreamGifDecoder.inputStreamToBytes(source);
        if (data == null) {
            return null;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        return this.byteBufferDecoder.decode(byteBuffer, width, height, options);
    }

    private static byte[] inputStreamToBytes(InputStream is) {
        int bufferSize = 16384;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
        }
        catch (IOException e) {
            if (Log.isLoggable((String)TAG, (int)5)) {
                Log.w((String)TAG, (String)"Error reading data from stream", (Throwable)e);
            }
            return null;
        }
        return buffer.toByteArray();
    }
}

