/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.lightbox;

import android.animation.ArgbEvaluator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.support.v4.content.ContextCompat;
import android.support.v7.app.AppCompatActivity;
import android.view.ViewGroup;
import android.widget.ImageView;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.lightbox.LightBoxImageView;
import io.intercom.android.sdk.lightbox.LightBoxListener;
import io.intercom.android.sdk.transforms.RoundedCornersTransform;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.TransitionOptions;
import io.intercom.com.bumptech.glide.load.Transformation;
import io.intercom.com.bumptech.glide.load.resource.drawable.DrawableTransitionOptions;
import io.intercom.com.bumptech.glide.request.RequestOptions;
import io.intercom.com.bumptech.glide.util.Util;

public class LightBoxActivity
extends AppCompatActivity
implements LightBoxListener {
    private static final String EXTRA_IMAGE_URL = "extra_image_url";
    private static final String EXTRA_ACTIVITY_FULLSCREEN = "extra_activity_fullscreen";
    private static final String CACHE_WIDTH = "cache_width";
    private static final String CACHE_HEIGHT = "cache_height";
    private static final int ANIMATION_TIME_MS = 300;
    public static final String TRANSITION_KEY = "lightbox_image";
    private String imageUrl = "";
    ViewGroup rootView;

    protected void onCreate(@Nullable Bundle savedInstanceState) {
        Bundle data = this.getIntent().getExtras();
        int width = 0;
        int height = 0;
        if (data != null) {
            this.imageUrl = data.getString(EXTRA_IMAGE_URL, "");
            width = data.getInt(CACHE_WIDTH);
            height = data.getInt(CACHE_HEIGHT);
            if (data.getBoolean(EXTRA_ACTIVITY_FULLSCREEN, false)) {
                this.requestWindowFeature(1);
                this.getWindow().setFlags(1024, 1024);
            }
        }
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_lightbox);
        this.rootView = (ViewGroup)this.findViewById(R.id.root_view);
        LightBoxImageView fullImage = (LightBoxImageView)this.findViewById(R.id.full_image);
        if (Build.VERSION.SDK_INT >= 21) {
            fullImage.setTransitionName(TRANSITION_KEY);
        }
        RequestOptions options = new RequestOptions().transform((Transformation)new RoundedCornersTransform(this.getResources().getDimensionPixelSize(R.dimen.intercom_image_rounded_corners))).error(R.drawable.intercom_error).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(this.imageUrl));
        if (Util.isValidDimensions((int)width, (int)height)) {
            options = options.override(width, height);
        }
        Glide.with((FragmentActivity)this).load(this.imageUrl).transition((TransitionOptions)DrawableTransitionOptions.withCrossFade()).apply(options).into((ImageView)fullImage);
        fullImage.setLightBoxListener(this);
        this.fadeIn();
    }

    private void fadeIn() {
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_full_transparent_full_black);
        int colorTo = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black_lightbox);
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(300L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                LightBoxActivity.this.rootView.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.start();
    }

    private void fadeOut() {
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black_lightbox);
        int colorTo = ContextCompat.getColor((Context)this, (int)R.color.intercom_full_transparent_full_black);
        ValueAnimator colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        colorAnimation.setDuration(300L);
        colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator) {
                LightBoxActivity.this.rootView.setBackgroundColor(((Integer)animator.getAnimatedValue()).intValue());
            }
        });
        colorAnimation.start();
    }

    public static Intent imageIntent(Context context, String url, boolean fullScreen, int width, int height) {
        return new Intent(context, LightBoxActivity.class).putExtra(EXTRA_IMAGE_URL, url).putExtra(CACHE_WIDTH, width).putExtra(CACHE_HEIGHT, height).putExtra(EXTRA_ACTIVITY_FULLSCREEN, fullScreen);
    }

    public void onBackPressed() {
        super.onBackPressed();
        this.closeLightBox();
    }

    @Override
    public void closeLightBox() {
        this.fadeOut();
        this.supportFinishAfterTransition();
    }
}

