/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.content.Context;
import android.content.SharedPreferences;
import com.google.auto.value.AutoValue;
import io.intercom.android.sdk.identity.AutoValue_AppIdentity;

@AutoValue
public abstract class AppIdentity {
    private static final String PREFS_API_KEY = "ApiKey";
    private static final String PREFS_APP_ID = "AppId";

    public static AppIdentity create(String apiKey, String appId) {
        return new AutoValue_AppIdentity(apiKey, appId);
    }

    public static AppIdentity loadFromDevice(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        String apiKey = prefs.getString(PREFS_API_KEY, "");
        String appId = prefs.getString(PREFS_APP_ID, "");
        return AppIdentity.create(apiKey, appId);
    }

    public void persist(Context context) {
        context.getSharedPreferences("INTERCOM_SDK_PREFS", 0).edit().putString(PREFS_API_KEY, this.apiKey()).putString(PREFS_APP_ID, this.appId()).apply();
    }

    public abstract String apiKey();

    public abstract String appId();
}

