/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.helpcenter;

import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.helpcenter.HelpCenterWebViewAction;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.com.google.gson.Gson;
import java.util.Map;

public class HelpCenterWebViewInterface {
    private static final String METRIC_EVENT = "METRIC_EVENT";
    private static final String TRACK_REACTION = "TRACK_REACTION";
    private final WebView webView;
    private final Gson gson;
    private final MetricTracker metricTracker;
    private final Api api;

    public HelpCenterWebViewInterface(WebView webView, Gson gson, MetricTracker metricTracker, Api api) {
        this.webView = webView;
        this.gson = gson;
        this.metricTracker = metricTracker;
        this.api = api;
    }

    @JavascriptInterface
    public void handleAction(String actionJson) {
        final HelpCenterWebViewAction action = (HelpCenterWebViewAction)this.gson.fromJson(actionJson, HelpCenterWebViewAction.class);
        switch (action.getType()) {
            case "METRIC_EVENT": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        Map<String, Object> actionValue = action.getValue();
                        String eventAction = (String)actionValue.get("action");
                        String eventObject = (String)actionValue.get("object");
                        String eventPlace = (String)actionValue.get("place");
                        Map eventMetaData = null;
                        if (actionValue.get("metadata") instanceof Map) {
                            eventMetaData = (Map)actionValue.get("metadata");
                        }
                        HelpCenterWebViewInterface.this.metricTracker.educateWebviewMetric(eventAction, eventObject, eventPlace, eventMetaData);
                    }
                });
                break;
            }
            case "TRACK_REACTION": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        Map<String, Object> actionValue = action.getValue();
                        Double articleId = (Double)actionValue.get("article_id");
                        Double reactionIndex = (Double)actionValue.get("reaction_index");
                        if (articleId == null || reactionIndex == null) {
                            return;
                        }
                        HelpCenterWebViewInterface.this.api.reactToLink(String.valueOf(articleId.intValue()), reactionIndex.intValue(), true);
                    }
                });
                break;
            }
        }
    }
}

