/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.request.target;

import android.graphics.drawable.Animatable;
import android.graphics.drawable.Drawable;
import android.support.annotation.Nullable;
import android.widget.ImageView;
import io.intercom.com.bumptech.glide.request.target.ViewTarget;
import io.intercom.com.bumptech.glide.request.transition.Transition;

public abstract class ImageViewTarget<Z>
extends ViewTarget<ImageView, Z>
implements Transition.ViewAdapter {
    @Nullable
    private Animatable animatable;

    public ImageViewTarget(ImageView view) {
        super(view);
    }

    @Override
    @Nullable
    public Drawable getCurrentDrawable() {
        return ((ImageView)this.view).getDrawable();
    }

    @Override
    public void setDrawable(Drawable drawable) {
        ((ImageView)this.view).setImageDrawable(drawable);
    }

    @Override
    public void onLoadStarted(@Nullable Drawable placeholder) {
        super.onLoadStarted(placeholder);
        this.setResourceInternal(null);
        this.setDrawable(placeholder);
    }

    @Override
    public void onLoadFailed(@Nullable Drawable errorDrawable) {
        super.onLoadFailed(errorDrawable);
        this.setResourceInternal(null);
        this.setDrawable(errorDrawable);
    }

    @Override
    public void onLoadCleared(@Nullable Drawable placeholder) {
        super.onLoadCleared(placeholder);
        this.setResourceInternal(null);
        this.setDrawable(placeholder);
    }

    @Override
    public void onResourceReady(Z resource, @Nullable Transition<? super Z> transition) {
        if (transition == null || !transition.transition(resource, this)) {
            this.setResourceInternal(resource);
        } else {
            this.maybeUpdateAnimatable(resource);
        }
    }

    @Override
    public void onStart() {
        if (this.animatable != null) {
            this.animatable.start();
        }
    }

    @Override
    public void onStop() {
        if (this.animatable != null) {
            this.animatable.stop();
        }
    }

    private void setResourceInternal(@Nullable Z resource) {
        this.maybeUpdateAnimatable(resource);
        this.setResource(resource);
    }

    private void maybeUpdateAnimatable(@Nullable Z resource) {
        if (resource instanceof Animatable) {
            this.animatable = (Animatable)resource;
            this.animatable.start();
        } else {
            this.animatable = null;
        }
    }

    protected abstract void setResource(@Nullable Z var1);
}

