/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import android.os.Handler;
import android.os.Looper;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.UserUpdateRequest;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import java.util.UUID;

public class UserUpdateBatcher {
    private final Handler handler;
    private final Provider<Api> apiProvider;
    private final Provider<AppConfig> appConfigProvider;
    private final Store<State> store;
    private UserUpdateRequest pendingUpdate;
    private String pendingUpdateIdentifier;

    public static UserUpdateBatcher create(Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider, Store<State> store) {
        return new UserUpdateBatcher(new Handler(Looper.getMainLooper()), apiProvider, appConfigProvider, store);
    }

    @VisibleForTesting
    UserUpdateBatcher(Handler handler, Provider<Api> apiProvider, Provider<AppConfig> appConfigProvider, Store<State> store) {
        this.apiProvider = apiProvider;
        this.handler = handler;
        this.appConfigProvider = appConfigProvider;
        this.store = store;
        this.resetPendingUpdate();
    }

    private void resetPendingUpdate() {
        this.pendingUpdate = new UserUpdateRequest();
        this.pendingUpdateIdentifier = UUID.randomUUID().toString();
    }

    public synchronized void submitPendingUpdate() {
        this.submitPendingUpdate(this.pendingUpdate);
    }

    private synchronized void submitPendingUpdate(String updateIdentifier) {
        if (!this.pendingUpdateIdentifier.equals(updateIdentifier)) {
            return;
        }
        this.submitPendingUpdate(this.pendingUpdate);
    }

    private void submitPendingUpdate(UserUpdateRequest update) {
        if (!update.isValidUpdate()) {
            return;
        }
        if (update.isNewSession()) {
            this.store.dispatch(Actions.sessionStarted());
        }
        this.apiProvider.get().updateUser(update);
        this.resetPendingUpdate();
    }

    public synchronized void updateUser(UserUpdateRequest userUpdateRequest) {
        if (!this.pendingUpdate.canMergeUpdate(userUpdateRequest)) {
            this.submitPendingUpdate();
        }
        boolean shouldScheduleUpdate = !this.pendingUpdate.isValidUpdate() || this.maxDelay(userUpdateRequest) < this.maxDelay(this.pendingUpdate);
        this.pendingUpdate = this.pendingUpdate.merge(userUpdateRequest);
        if (shouldScheduleUpdate) {
            this.submitPendingUpdateWithDelay(this.maxDelay(this.pendingUpdate));
        }
    }

    private void submitPendingUpdateWithDelay(long delayMillis) {
        if (delayMillis > 0L) {
            final String updateIdentifier = this.pendingUpdateIdentifier;
            this.handler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    UserUpdateBatcher.this.submitPendingUpdate(updateIdentifier);
                }
            }, delayMillis);
        } else {
            this.submitPendingUpdate();
        }
    }

    private long maxDelay(UserUpdateRequest update) {
        AppConfig appConfig = this.appConfigProvider.get();
        return update.isInternalUpdate() ? appConfig.getPingDelayMs() : appConfig.getBatchUserUpdatePeriodMs();
    }
}

