/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import android.support.annotation.Nullable;
import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.AutoValue_ConversationList;
import io.intercom.android.sdk.models.Conversation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class ConversationList {
    public static ConversationList create(List<Conversation> conversations, Set<String> unreadConversationIds, boolean morePagesAvailable) {
        return new AutoValue_ConversationList(conversations, unreadConversationIds, morePagesAvailable);
    }

    public abstract List<Conversation> getConversations();

    public abstract Set<String> getUnreadConversationIds();

    public abstract boolean hasMorePages();

    public static final class Builder {
        @Nullable
        List<Conversation.Builder> conversations;
        @Nullable
        List<String> unread_conversation_ids;
        boolean more_pages_available;

        public ConversationList build() {
            ArrayList<Conversation> conversations = new ArrayList<Conversation>(CollectionUtils.capacityFor(this.conversations));
            if (this.conversations != null) {
                for (Conversation.Builder conversationBuilder : this.conversations) {
                    if (conversationBuilder == null) continue;
                    conversations.add(conversationBuilder.build());
                }
            }
            HashSet<String> unreadConversationIds = new HashSet<String>(CollectionUtils.capacityFor(this.unread_conversation_ids));
            if (this.unread_conversation_ids != null) {
                for (String id2 : this.unread_conversation_ids) {
                    if (id2 == null) continue;
                    unreadConversationIds.add(id2);
                }
            }
            return ConversationList.create(conversations, unreadConversationIds, this.more_pages_available);
        }
    }
}

