/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.overlay;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.activities.IntercomNoteActivity;
import io.intercom.android.sdk.activities.IntercomPostActivity;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConfigUpdateEvent;
import io.intercom.android.sdk.overlay.DefaultLauncher;
import io.intercom.android.sdk.overlay.DefaultLauncherPresenter;
import io.intercom.android.sdk.overlay.InAppNotificationManager;
import io.intercom.android.sdk.overlay.LauncherOpenBehaviour;
import io.intercom.android.sdk.state.OverlayState;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Selectors;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import io.intercom.android.sdk.utilities.ViewUtils;
import io.intercom.com.bumptech.glide.RequestManager;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.Subscribe;
import java.util.List;

public class OverlayManager
implements InAppNotificationManager.Listener,
Store.Subscriber2<Integer, OverlayState> {
    final DefaultLauncherPresenter launcherPresenter;
    final InAppNotificationManager inAppNotificationManager;
    private final MetricTracker metricTracker;
    private final Store<State> store;
    private final Application application;
    private final Provider<AppConfig> appConfigProvider;
    private final Handler handler;
    private final UserIdentity userIdentity;
    private final RequestManager requestManager;
    private final Twig twig = LumberMill.getLogger();

    public OverlayManager(Application application, Bus bus, Store<State> store, Provider<AppConfig> appConfigProvider, MetricTracker metricTracker, UserIdentity userIdentity, RequestManager requestManager) {
        this.application = application;
        this.appConfigProvider = appConfigProvider;
        this.store = store;
        this.metricTracker = metricTracker;
        this.userIdentity = userIdentity;
        this.requestManager = requestManager;
        LayoutInflater inflater = LayoutInflater.from((Context)application);
        this.handler = new Handler(Looper.getMainLooper());
        this.inAppNotificationManager = new InAppNotificationManager(inflater, this.handler, this, metricTracker, appConfigProvider, new ContextLocaliser(appConfigProvider), requestManager);
        LauncherOpenBehaviour launcherOpenBehaviour = new LauncherOpenBehaviour(appConfigProvider, store, LauncherOpenBehaviour.LauncherType.DEFAULT, metricTracker);
        this.launcherPresenter = new DefaultLauncherPresenter(inflater, launcherOpenBehaviour, metricTracker);
        bus.register((Object)this);
        store.subscribeToChanges(Selectors.UNREAD_COUNT, Selectors.OVERLAY, this);
    }

    @Override
    public void onStateChange(final Integer unreadCount, OverlayState overlayState) {
        Intercom.Visibility inAppVisibility = overlayState.notificationVisibility();
        Activity activity = overlayState.resumedHostActivity();
        List<Conversation> conversations = overlayState.conversations();
        this.launcherPresenter.setBottomPadding(overlayState.bottomPadding());
        this.inAppNotificationManager.setBottomPadding(overlayState.bottomPadding());
        if (activity == null || activity.isFinishing() || Build.VERSION.SDK_INT >= 17 && activity.isDestroyed()) {
            return;
        }
        if (this.shouldDisplayNotifications(conversations, inAppVisibility, activity)) {
            this.preloadAvatarThenDisplayNotifications(conversations, inAppVisibility, activity, this.userIdentity.getFingerprint());
        } else if (this.shouldDisplayLauncher(conversations, inAppVisibility, overlayState.launcherVisibility(), activity)) {
            final ViewGroup root = this.getRootView(activity);
            ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                @Override
                public void run() {
                    OverlayManager.this.inAppNotificationManager.reset(root);
                    OverlayManager.this.launcherPresenter.setUnreadCount(unreadCount);
                    int backgroundColor = ((AppConfig)OverlayManager.this.appConfigProvider.get()).getBaseColor();
                    OverlayManager.this.launcherPresenter.displayLauncherOnAttachedRoot(root, backgroundColor);
                }
            });
        } else {
            this.removeOverlaysIfPresent(activity);
        }
    }

    public void softReset() {
        this.cancelAnimations();
        Activity hostActivity = this.store.select(Selectors.OVERLAY).resumedHostActivity();
        if (hostActivity != null) {
            this.removeOverlaysIfPresent(hostActivity);
        }
    }

    public void sendUnreadConversationsReceivedMetric(List<Conversation> conversations) {
        for (Conversation conversation : conversations) {
            Part lastPart = conversation.getLastPart();
            if (Part.DeliveryOption.SUMMARY == lastPart.getDeliveryOption()) {
                if (lastPart.isInitialMessage()) {
                    this.metricTracker.receivedMessageFromSnippetWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId(), lastPart.getMessageStyle());
                    continue;
                }
                this.metricTracker.receivedReplyFromSnippetWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId());
                continue;
            }
            this.metricTracker.receivedMessageFromFullWhenClosed(lastPart.hasAttachments(), lastPart.isLinkCard(), conversation.getId(), lastPart.getId(), lastPart.getMessageStyle());
        }
    }

    @Subscribe
    public void configUpdated(ConfigUpdateEvent event) {
        OverlayState state = this.store.select(Selectors.OVERLAY);
        Activity hostActivity = state.resumedHostActivity();
        if (this.shouldDisplayLauncher(state.conversations(), state.notificationVisibility(), state.launcherVisibility(), hostActivity)) {
            final ViewGroup root = this.getRootView(hostActivity);
            ViewUtils.waitForViewAttachment((View)root, new Runnable(){

                @Override
                public void run() {
                    int backgroundColor = ((AppConfig)OverlayManager.this.appConfigProvider.get()).getBaseColor();
                    OverlayManager.this.launcherPresenter.displayLauncherOnAttachedRoot(root, backgroundColor);
                }
            });
        } else {
            this.launcherPresenter.setLauncherBackgroundColor(this.appConfigProvider.get().getBaseColor());
        }
    }

    public void cancelAnimations() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public void removeOverlaysIfPresent(Activity activity) {
        final View root = activity.findViewById(R.id.intercom_overlay_root);
        activity.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (root != null) {
                    OverlayManager.this.launcherPresenter.removeLauncher();
                    OverlayManager.this.inAppNotificationManager.reset((ViewGroup)root);
                    if (root.getParent() != null) {
                        ((ViewGroup)root.getParent()).removeView(root);
                    }
                }
            }
        });
    }

    void preloadAvatarThenDisplayNotifications(final List<Conversation> conversations, final Intercom.Visibility notificationVisibility, final Activity activity, final String fingerprint) {
        AvatarUtils.preloadAvatar(conversations.get(0).getLastAdmin().getAvatar(), new Runnable(){

            @Override
            public void run() {
                if (fingerprint.equals(OverlayManager.this.userIdentity.getFingerprint()) && OverlayManager.this.shouldDisplayNotifications(conversations, notificationVisibility, activity)) {
                    OverlayManager.this.displayNotifications(conversations, activity);
                }
            }
        }, this.requestManager);
    }

    void displayNotifications(final List<Conversation> conversations, Activity activity) {
        final ViewGroup rootView = this.getRootView(activity);
        Conversation conversation = conversations.get(0);
        String messageStyle = conversation.getLastPart().getMessageStyle();
        Part.DeliveryOption deliveryOption = conversation.getLastPart().getDeliveryOption();
        if (conversations.size() > 1 || this.inAppNotificationManager.isDisplaying() || deliveryOption == Part.DeliveryOption.SUMMARY || deliveryOption == Part.DeliveryOption.FULL && "chat".equals(messageStyle)) {
            if (this.launcherPresenter.isDisplaying()) {
                final DefaultLauncher defaultLauncher = this.launcherPresenter.getAndUnsetLauncher();
                if (conversations.size() == 1) {
                    defaultLauncher.pulseForTransformation((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                                public void onAnimationEnd(Animator animation) {
                                    defaultLauncher.removeView();
                                }
                            });
                            OverlayManager.this.inAppNotificationManager.displayNotifications(rootView, conversations);
                        }
                    });
                } else {
                    defaultLauncher.fadeOffScreen((Animator.AnimatorListener)new AnimatorListenerAdapter(){

                        public void onAnimationEnd(Animator animation) {
                            defaultLauncher.removeView();
                            OverlayManager.this.inAppNotificationManager.displayNotifications(rootView, conversations);
                        }
                    });
                }
            } else {
                this.inAppNotificationManager.displayNotifications(rootView, conversations);
            }
        } else if (deliveryOption == Part.DeliveryOption.FULL) {
            if ("post".equals(messageStyle)) {
                this.openPost(conversation, false);
            } else if ("note".equals(messageStyle)) {
                this.openNote(conversation, false);
            }
        }
    }

    @Override
    public ViewGroup getRootView() throws Exception {
        Activity activity = this.store.select(Selectors.OVERLAY).resumedHostActivity();
        if (activity == null) {
            throw new NullPointerException();
        }
        return this.getRootView(activity);
    }

    private ViewGroup getRootView(Activity activity) {
        ViewGroup root = (ViewGroup)activity.findViewById(R.id.intercom_overlay_root);
        if (root == null) {
            root = new FrameLayout((Context)activity);
            root.setClipChildren(false);
            root.setClipToPadding(false);
            root.setFitsSystemWindows(true);
            root.setId(R.id.intercom_overlay_root);
            activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1, 80));
        }
        return root;
    }

    @Override
    public void markAsDismissed(Conversation conversation) {
        this.store.dispatch(Actions.conversationMarkedAsDismissed(conversation));
    }

    @Override
    public void openNotification(Conversation conversation) {
        Part lastPart = conversation.getLastAdminPart();
        String messageStyle = lastPart.getMessageStyle();
        if ("post".equals(messageStyle)) {
            this.openPost(conversation, true);
        } else if ("note".equals(messageStyle)) {
            this.openNote(conversation, true);
        } else {
            this.openMessenger(conversation);
            if ("chat".equals(messageStyle) && Part.DeliveryOption.FULL == lastPart.getDeliveryOption()) {
                this.metricTracker.openedConversationFromFull(conversation.getId(), lastPart.getId());
            } else {
                this.metricTracker.openedConversationFromSnippet(conversation.getId(), lastPart.getId());
            }
        }
    }

    private void openMessenger(Conversation conversation) {
        this.application.startActivity(IntercomMessengerActivity.openConversation((Context)this.application, conversation.getId(), conversation.getLastParticipatingAdmin()));
    }

    private void openPost(Conversation conversation, boolean openedFromSnippet) {
        Part lastPart = conversation.getLastPart();
        if (openedFromSnippet) {
            this.metricTracker.viewedInAppFromSnippet(conversation.getId(), lastPart.getId());
        } else {
            this.metricTracker.viewedInAppFromFull(conversation.getId(), lastPart.getId());
        }
        this.application.startActivity(IntercomPostActivity.buildPostIntent((Context)this.application, conversation.getLastPart(), conversation.getId(), conversation.getLastParticipatingAdmin(), true));
    }

    private void openNote(Conversation conversation, boolean openedFromSnippet) {
        Part lastPart = conversation.getLastPart();
        if (openedFromSnippet) {
            this.metricTracker.viewedInAppFromSnippet(conversation.getId(), lastPart.getId());
        } else {
            this.metricTracker.viewedInAppFromFull(conversation.getId(), lastPart.getId());
        }
        try {
            this.application.startActivity(IntercomNoteActivity.buildNoteIntent((Context)this.application, lastPart, conversation.getId(), conversation.getLastParticipatingAdmin()));
        }
        catch (IllegalArgumentException e) {
            this.twig.internal("Overlay", "Error loading the note " + e.getMessage());
        }
    }

    boolean shouldDisplayNotifications(List<Conversation> conversations, Intercom.Visibility notificationVisibility, @Nullable Activity hostActivity) {
        return notificationVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && !conversations.isEmpty() && hostActivity != null;
    }

    boolean shouldDisplayLauncher(List<Conversation> conversations, Intercom.Visibility notificationVisibility, Intercom.Visibility launcherVisibility, @Nullable Activity hostActivity) {
        if (notificationVisibility == Intercom.Visibility.VISIBLE) {
            for (Conversation c : conversations) {
                if (Part.DeliveryOption.BADGE == c.getLastPart().getDeliveryOption()) continue;
                return false;
            }
        }
        return launcherVisibility == Intercom.Visibility.VISIBLE && !this.userIdentity.isSoftReset() && this.userIdentity.identityExists() && this.appConfigProvider.get().isReceivedFromServer() && hostActivity != null;
    }

    public void refreshStateBecauseUserIdentityIsNotInStoreYet() {
        this.onStateChange(this.store.select(Selectors.UNREAD_COUNT), this.store.select(Selectors.OVERLAY));
    }
}

