/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.model;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.com.bumptech.glide.Priority;
import io.intercom.com.bumptech.glide.load.DataSource;
import io.intercom.com.bumptech.glide.load.Options;
import io.intercom.com.bumptech.glide.load.data.DataFetcher;
import io.intercom.com.bumptech.glide.load.data.mediastore.MediaStoreUtil;
import io.intercom.com.bumptech.glide.load.model.ModelLoader;
import io.intercom.com.bumptech.glide.load.model.ModelLoaderFactory;
import io.intercom.com.bumptech.glide.load.model.MultiModelLoaderFactory;
import io.intercom.com.bumptech.glide.signature.ObjectKey;
import java.io.File;
import java.io.FileNotFoundException;

public final class MediaStoreFileLoader
implements ModelLoader<Uri, File> {
    private final Context context;

    MediaStoreFileLoader(Context context) {
        this.context = context;
    }

    @Override
    public ModelLoader.LoadData<File> buildLoadData(Uri uri, int width, int height, Options options) {
        return new ModelLoader.LoadData<File>(new ObjectKey(uri), new FilePathFetcher(this.context, uri));
    }

    @Override
    public boolean handles(Uri uri) {
        return MediaStoreUtil.isMediaStoreUri(uri);
    }

    public static final class Factory
    implements ModelLoaderFactory<Uri, File> {
        private final Context context;

        public Factory(Context context) {
            this.context = context;
        }

        @Override
        public ModelLoader<Uri, File> build(MultiModelLoaderFactory multiFactory) {
            return new MediaStoreFileLoader(this.context);
        }

        @Override
        public void teardown() {
        }
    }

    private static class FilePathFetcher
    implements DataFetcher<File> {
        private static final String[] PROJECTION = new String[]{"_data"};
        private final Context context;
        private final Uri uri;

        FilePathFetcher(Context context, Uri uri) {
            this.context = context;
            this.uri = uri;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void loadData(Priority priority, DataFetcher.DataCallback<? super File> callback) {
            Cursor cursor = this.context.getContentResolver().query(this.uri, PROJECTION, null, null, null);
            String filePath = null;
            if (cursor != null) {
                try {
                    if (cursor.moveToFirst()) {
                        filePath = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    }
                }
                finally {
                    cursor.close();
                }
            }
            if (TextUtils.isEmpty(filePath)) {
                callback.onLoadFailed(new FileNotFoundException("Failed to find file path for: " + this.uri));
            } else {
                callback.onDataReady(new File(filePath));
            }
        }

        @Override
        public void cleanup() {
        }

        @Override
        public void cancel() {
        }

        @Override
        @NonNull
        public Class<File> getDataClass() {
            return File.class;
        }

        @Override
        @NonNull
        public DataSource getDataSource() {
            return DataSource.LOCAL;
        }
    }
}

