/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.LifecycleTracker;
import io.intercom.android.sdk.MainThreadBus;
import io.intercom.android.sdk.NexusWrapper;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.ResetManager;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.ApiFactory;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.JsCore;
import io.intercom.android.sdk.api.UserUpdateBatcher;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.conversation.SoundPlayer;
import io.intercom.android.sdk.exceptions.IntercomIntegrationException;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricTracker;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.metrics.ops.OpsMetricTracker;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.overlay.OverlayManager;
import io.intercom.android.sdk.push.SystemNotificationManager;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.android.sdk.store.StoreFactory;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ActivityFinisher;
import io.intercom.android.sdk.utilities.SystemSettings;
import io.intercom.com.google.gson.Gson;
import io.intercom.com.squareup.otto.Bus;
import io.intercom.com.squareup.otto.ThreadEnforcer;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Injector {
    @Nullable
    @SuppressLint(value={"StaticFieldLeak"})
    private static Injector instance;
    private static final Twig TWIG;
    private final Application application;
    private final AppIdentity appIdentity;
    private final AppConfig appConfig;
    private final UserIdentity userIdentity;
    private final ActivityFinisher activityFinisher = new ActivityFinisher();
    @Nullable
    private MainThreadBus bus;
    @Nullable
    private NexusWrapper nexusClient;
    @Nullable
    private DeDuper superDeDuper;
    @Nullable
    private Api api;
    @Nullable
    private MetricsStore metricsStore;
    @Nullable
    private MetricTracker metricTracker;
    @Nullable
    private OpsMetricTracker opsMetricTracker;
    @Nullable
    private OverlayManager overlayManager;
    @Nullable
    private LifecycleTracker lifecycleTracker;
    @Nullable
    private SystemNotificationManager systemNotificationManager;
    @Nullable
    private Store<State> store;
    @Nullable
    private UserUpdateBatcher userUpdateBatcher;
    @Nullable
    private ResetManager resetManager;
    @Nullable
    private Gson gson;
    @Nullable
    private JsCore jsCore;
    private final Provider<AppConfig> appConfigProvider = new Provider<AppConfig>(){

        @Override
        public AppConfig get() {
            return Injector.this.appConfig;
        }
    };
    private final Provider<NexusClient> nexusClientProvider = new Provider<NexusClient>(){

        @Override
        public NexusClient get() {
            return Injector.this.getNexusClient();
        }
    };
    private final Provider<UserUpdateBatcher> userUpdateBatcherProvider = new Provider<UserUpdateBatcher>(){

        @Override
        public UserUpdateBatcher get() {
            return Injector.this.getUserUpdateBatcher();
        }
    };
    private final Provider<Api> apiProvider = new Provider<Api>(){

        @Override
        public Api get() {
            return Injector.this.getApi();
        }
    };
    private final Provider<OverlayManager> overlayManagerProvider = new Provider<OverlayManager>(){

        @Override
        public OverlayManager get() {
            return Injector.this.getOverlayManager();
        }
    };
    private final Provider<UserIdentity> userIdentityProvider = new Provider<UserIdentity>(){

        @Override
        public UserIdentity get() {
            return Injector.this.getUserIdentity();
        }
    };
    protected final Provider<JsCore> jsCoreProvider = new Provider<JsCore>(){

        @Override
        public JsCore get() {
            return Injector.this.getJsCore();
        }
    };

    public static synchronized void initIfCachedCredentials(Application application) {
        if (instance != null) {
            return;
        }
        AppIdentity appIdentity = AppIdentity.loadFromDevice((Context)application);
        String apiKey = appIdentity.apiKey();
        String appId = appIdentity.appId();
        if (!appId.isEmpty() && !apiKey.isEmpty()) {
            Injector.initWithAppCredentials(application, apiKey, appId);
        }
    }

    static synchronized void initWithAppCredentials(Application application, String apiKey, String appId) {
        if (instance != null) {
            return;
        }
        TWIG.internal("Injector", "Initializing");
        AppIdentity appIdentity = AppIdentity.create(apiKey, appId);
        appIdentity.persist((Context)application);
        AppConfig appConfig = new AppConfig((Context)application);
        instance = new Injector(application, appIdentity, appConfig, new UserIdentity((Context)application));
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)instance.getLifecycleTracker());
    }

    protected Injector(Application application, AppIdentity appIdentity, AppConfig appConfig, UserIdentity userIdentity) {
        this.application = application;
        this.appIdentity = appIdentity;
        this.appConfig = appConfig;
        this.userIdentity = userIdentity;
    }

    public static synchronized boolean isNotInitialised() {
        return instance == null;
    }

    public static synchronized Injector get() {
        if (instance == null) {
            String message = "Intercom was not initialized correctly, Intercom.initialize() needs to be called in onCreate() in your Application class.";
            throw new IntercomIntegrationException(message);
        }
        return instance;
    }

    public Application getApplication() {
        return this.application;
    }

    public Provider<AppConfig> getAppConfigProvider() {
        return this.appConfigProvider;
    }

    public AppIdentity getAppIdentity() {
        return this.appIdentity;
    }

    public UserIdentity getUserIdentity() {
        return this.userIdentity;
    }

    public synchronized Bus getBus() {
        if (this.bus == null) {
            this.bus = new MainThreadBus(ThreadEnforcer.ANY);
        }
        return this.bus;
    }

    public synchronized NexusClient getNexusClient() {
        if (this.nexusClient == null) {
            this.nexusClient = new NexusWrapper(LumberMill.getNexusTwig(), this.getBus(), this.getStore(), this.getNexusDebouncePeriod());
        }
        return this.nexusClient;
    }

    protected long getNexusDebouncePeriod() {
        return TimeUnit.SECONDS.toMillis(1L);
    }

    public synchronized DeDuper getDeDuper() {
        if (this.superDeDuper == null) {
            SharedPreferences prefs = this.application.getSharedPreferences("INTERCOM_DEDUPER_PREFS", 0);
            this.superDeDuper = new DeDuper(this.appConfigProvider, prefs);
            this.superDeDuper.readPersistedCachedAttributes();
        }
        return this.superDeDuper;
    }

    public synchronized Api getApi() {
        if (this.api == null) {
            String hostname = ApiFactory.getHostname(this.appIdentity);
            this.api = ApiFactory.create((Context)this.getApplication(), this.appIdentity, this.userIdentity, this.getBus(), this.getStore(), hostname, this.appConfigProvider, this.getGson(), this.jsCoreProvider);
        }
        this.api.updateMaxRequests();
        return this.api;
    }

    public synchronized Gson getGson() {
        if (this.gson == null) {
            this.gson = new Gson();
        }
        return this.gson;
    }

    public synchronized MetricTracker getMetricTracker() {
        if (this.metricTracker == null) {
            this.metricTracker = new MetricTracker(this.userIdentity, this.getMetricsStore());
        }
        return this.metricTracker;
    }

    public synchronized MetricsStore getMetricsStore() {
        if (this.metricsStore == null) {
            this.metricsStore = new MetricsStore((Context)this.getApplication(), this.getApiProvider(), this.appConfigProvider);
        }
        return this.metricsStore;
    }

    public synchronized OpsMetricTracker getOpsMetricTracker() {
        if (this.opsMetricTracker == null) {
            this.opsMetricTracker = new OpsMetricTracker(this.getMetricsStore(), this.getTimeProvider());
        }
        return this.opsMetricTracker;
    }

    public synchronized OverlayManager getOverlayManager() {
        if (this.overlayManager == null) {
            this.overlayManager = new OverlayManager(this.getApplication(), this.getBus(), this.getStore(), this.appConfigProvider, this.getMetricTracker(), this.userIdentity);
        }
        return this.overlayManager;
    }

    public synchronized Store<State> getStore() {
        if (this.store == null) {
            this.store = StoreFactory.createStore(this.apiProvider, this.appConfigProvider, this.nexusClientProvider, this.overlayManagerProvider, this.userUpdateBatcherProvider, new SoundPlayer((Context)this.application, this.appConfigProvider), this.userIdentityProvider, (Context)this.application, LumberMill.getLogger(), this.getBus());
        }
        return this.store;
    }

    public TimeProvider getTimeProvider() {
        return TimeProvider.SYSTEM;
    }

    public synchronized SystemNotificationManager getSystemNotificationManager() {
        if (this.systemNotificationManager == null) {
            NotificationManager notificationManager = (NotificationManager)this.application.getSystemService("notification");
            this.systemNotificationManager = new SystemNotificationManager(notificationManager);
        }
        return this.systemNotificationManager;
    }

    public synchronized LifecycleTracker getLifecycleTracker() {
        if (this.lifecycleTracker == null) {
            this.lifecycleTracker = LifecycleTracker.create(this.getSystemNotificationManager(), this.getMetricsStore(), this.getDeDuper(), this.getTimeProvider(), this.getUserUpdateBatcher(), this.getStore(), this.getResetManager(), SystemSettings.getTransitionScale((Context)this.application));
        }
        return this.lifecycleTracker;
    }

    public synchronized UserUpdateBatcher getUserUpdateBatcher() {
        if (this.userUpdateBatcher == null) {
            this.userUpdateBatcher = UserUpdateBatcher.create(this.getApiProvider(), this.appConfigProvider, this.getStore());
        }
        return this.userUpdateBatcher;
    }

    public synchronized ResetManager getResetManager() {
        if (this.resetManager == null) {
            this.resetManager = new ResetManager(this.getApiProvider(), this.getUserIdentity(), this.getOverlayManager(), this.appConfigProvider, this.getStore(), this.getUserUpdateBatcher(), (Context)this.application, this.activityFinisher);
        }
        return this.resetManager;
    }

    synchronized JsCore getJsCore() {
        if (this.jsCore == null) {
            this.jsCore = JsCore.create((Context)this.application, this.appIdentity, this.userIdentityProvider, this.getGson());
        }
        return this.jsCore;
    }

    public Provider<UserUpdateBatcher> getUserUpdateBatcherProvider() {
        return this.userUpdateBatcherProvider;
    }

    public Provider<Api> getApiProvider() {
        return this.apiProvider;
    }

    public ActivityFinisher getActivityFinisher() {
        return this.activityFinisher;
    }

    @VisibleForTesting
    static void setSharedInstance(Injector injector) {
        instance = injector;
    }

    static {
        TWIG = LumberMill.getLogger();
    }
}

