/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.support.annotation.Nullable;
import android.view.MotionEvent;
import android.view.View;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.views.IntercomLinkView;
import java.util.List;

class IntercomLinkPresenter {
    final IntercomLinkView intercomLinkView;
    private final Provider<AppConfig> appConfigProvider;
    private final Api api;
    private final List<Part> conversationParts;
    private final String conversationId;
    private boolean wasAtBottom = false;

    IntercomLinkPresenter(IntercomLinkView intercomLinkView, Provider<AppConfig> appConfigProvider, Api api, List<Part> conversationParts, String conversationId) {
        this.intercomLinkView = intercomLinkView;
        this.appConfigProvider = appConfigProvider;
        this.api = api;
        this.conversationParts = conversationParts;
        this.conversationId = conversationId;
    }

    void setup(IntercomLinkHost host) {
        this.intercomLinkView.setAlpha(0.0f);
        if (!this.shouldShowIntercomLink()) {
            return;
        }
        int extraBottomPadding = this.intercomLinkView.getResources().getDimensionPixelSize(R.dimen.intercom_link_height);
        host.addBottomPadding(extraBottomPadding);
        this.intercomLinkView.setOnTouchListener(new View.OnTouchListener(){

            public boolean onTouch(View v, MotionEvent event) {
                boolean interceptEvent;
                boolean bl = interceptEvent = IntercomLinkPresenter.this.intercomLinkView.getAlpha() == 1.0f;
                if (interceptEvent && 1 == event.getActionMasked()) {
                    IntercomLinkPresenter.this.intercomLinkView.followIntercomLink(IntercomLinkPresenter.this.appConfigProvider, IntercomLinkPresenter.this.getFirstMessagePart(), IntercomLinkPresenter.this.api);
                }
                return interceptEvent;
            }
        });
        if (this.conversationId.isEmpty()) {
            this.intercomLinkView.show();
        }
    }

    void updateIntercomLink(IntercomLinkHost host) {
        if (!this.shouldShowIntercomLink()) {
            return;
        }
        boolean isAtBottom = host.isAtBottom();
        if (isAtBottom && !this.wasAtBottom) {
            this.intercomLinkView.show();
        } else if (this.wasAtBottom && !isAtBottom) {
            this.intercomLinkView.hide();
        }
        this.wasAtBottom = host.isAtBottom();
    }

    void onProfileScrolled(@Nullable View lastConversationChildView) {
        if (!this.shouldShowIntercomLink()) {
            return;
        }
        if (lastConversationChildView != null) {
            this.intercomLinkView.hideIfIntersectedOrShow(lastConversationChildView);
        }
    }

    private boolean shouldShowIntercomLink() {
        return this.appConfigProvider.get().shouldShowIntercomLink();
    }

    private Part getFirstMessagePart() {
        for (Part part : this.conversationParts) {
            if (!part.isMessagePart()) continue;
            return part;
        }
        return Part.NULL;
    }

    static interface IntercomLinkHost {
        public void addBottomPadding(int var1);

        public boolean isAtBottom();
    }
}

