/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.support.annotation.VisibleForTesting;
import android.webkit.WebView;
import java.util.ArrayList;
import java.util.Collection;

class JavascriptRunner {
    private final WebView webView;
    private final Collection<Runnable> actionsAfterLoad;
    private boolean hasLoaded = false;

    JavascriptRunner(WebView webView) {
        this(webView, new ArrayList<Runnable>());
    }

    @VisibleForTesting
    JavascriptRunner(WebView webView, Collection<Runnable> actionsAfterLoad) {
        this.webView = webView;
        this.actionsAfterLoad = actionsAfterLoad;
    }

    synchronized void runPendingScripts() {
        this.hasLoaded = true;
        for (Runnable action : this.actionsAfterLoad) {
            action.run();
        }
        this.clearPendingScripts();
    }

    synchronized void clearPendingScripts() {
        this.actionsAfterLoad.clear();
    }

    synchronized void run(final String script) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                JavascriptRunner.this.webView.loadUrl("javascript:" + script);
            }
        };
        if (this.hasLoaded) {
            this.webView.post(runnable);
        } else {
            this.actionsAfterLoad.add(runnable);
        }
    }
}

