/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.TargetApi;
import android.content.Intent;
import android.net.Uri;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import io.intercom.android.sdk.conversation.JavascriptRunner;

class ConversationWebViewClient
extends WebViewClient {
    private final JavascriptRunner jsRunner;
    private final String webPageUrl;

    ConversationWebViewClient(JavascriptRunner jsRunner, String webPageUrl) {
        this.jsRunner = jsRunner;
        this.webPageUrl = webPageUrl;
    }

    @TargetApi(value=21)
    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, WebResourceRequest request) {
        return this.shouldInterceptRequest(view, request.getUrl().toString());
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(WebView view, String url) {
        if (this.isRequestForFavicon(url)) {
            return new WebResourceResponse(null, null, null);
        }
        return null;
    }

    public void onPageFinished(WebView view, String url) {
        this.jsRunner.runPendingScripts();
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (TextUtils.isEmpty((CharSequence)url) || this.webPageUrl.equals(url)) {
            return false;
        }
        view.getContext().startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
        return true;
    }

    @TargetApi(value=21)
    public boolean shouldOverrideUrlLoading(WebView view, WebResourceRequest request) {
        return this.shouldOverrideUrlLoading(view, request.getUrl().toString());
    }

    private boolean isRequestForFavicon(String url) {
        return url.contains("/favicon.ico");
    }
}

