/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views.holder;

import android.content.ClipboardManager;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.ImageView;
import android.widget.TextView;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.views.LockableScrollView;
import io.intercom.android.sdk.views.holder.BlocksPartViewHolder;
import io.intercom.android.sdk.views.holder.ConversationListener;

public class ContainerCardViewHolder
extends BlocksPartViewHolder {
    final LockableScrollView lockableScrollView;
    @Nullable
    ImageView arrowExpander;
    private final int viewType;
    private final View fade;
    private final TextView title;

    public ContainerCardViewHolder(View itemView, int viewType, ConversationListener conversationListener, @Nullable ClipboardManager clipboardManager, boolean allowExpansionArrow) {
        super(itemView, conversationListener, clipboardManager);
        this.viewType = viewType;
        this.title = (TextView)itemView.findViewById(R.id.intercom_container_card_title);
        this.fade = itemView.findViewById(R.id.intercom_container_fade_view);
        this.lockableScrollView = (LockableScrollView)itemView.findViewById(R.id.cell_content);
        this.lockableScrollView.setScrollingEnabled(false);
        if (viewType == 3) {
            if (allowExpansionArrow) {
                this.arrowExpander = (ImageView)itemView.findViewById(R.id.expand_arrow);
            }
            this.lockableScrollView.setExpanded(!allowExpansionArrow);
        } else {
            this.lockableScrollView.setExpanded(false);
        }
        final View blocksView = itemView.findViewById(R.id.cellLayout);
        blocksView.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            public boolean onPreDraw() {
                blocksView.getViewTreeObserver().removeOnPreDrawListener((ViewTreeObserver.OnPreDrawListener)this);
                ContainerCardViewHolder.this.setupViews();
                return false;
            }
        });
    }

    @Override
    public void bind(Part part, ViewGroup blocksLayout) {
        ViewGroup blocks = this.setUpHolderBlocks(part, this.cellLayout, this.bubble, blocksLayout);
        this.showAvatar(part.getParticipant(), this.networkAvatar);
        CharSequence titleString = Phrase.from(this.title.getContext(), R.string.intercom_teammate_from_company).put("name", part.getParticipant().getForename()).put("company", Injector.get().getAppConfigProvider().get().getName()).format();
        this.title.setText(titleString);
        this.checkForEntranceAnimation(this.viewType, part, this.networkAvatar, this.cellLayout, blocks);
    }

    public void onClick(View v) {
        int adapterPosition = this.getAdapterPosition();
        if (adapterPosition != -1) {
            this.conversationListener.onContainerCardClicked(adapterPosition, this);
        }
    }

    public void toggleExpanded() {
        this.runOnMainThread(new Runnable(){

            @Override
            public void run() {
                if (ContainerCardViewHolder.this.arrowExpander != null && ContainerCardViewHolder.this.arrowExpander.getVisibility() == 0) {
                    ContainerCardViewHolder.this.lockableScrollView.toggleExpanded();
                    ContainerCardViewHolder.this.setupViews();
                }
            }
        });
    }

    void setupViews() {
        if (this.viewType == 2) {
            this.layoutForPost();
        } else if (this.arrowExpander == null) {
            this.layoutForExpandedNoteWithoutArrow();
        } else if (this.lockableScrollView.isExpanded()) {
            this.layoutForExpandedNoteWithArrow();
        } else {
            this.layoutForCollapsedNoteWithArrow();
        }
    }

    private void layoutForPost() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(8);
        }
        this.fade.setVisibility(this.contentIsOverflowing() ? 0 : 4);
    }

    private boolean contentIsOverflowing() {
        int scrollHeight;
        int childHeight = this.lockableScrollView.getChildAt(0).getMeasuredHeight();
        return childHeight > (scrollHeight = this.lockableScrollView.getMaxHeight());
    }

    private void layoutForExpandedNoteWithoutArrow() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(8);
        }
        this.fade.setVisibility(4);
    }

    private void layoutForExpandedNoteWithArrow() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(this.contentIsOverflowing() ? 0 : 8);
            this.arrowExpander.setScaleY(-1.0f);
        }
        this.fade.setVisibility(4);
    }

    private void layoutForCollapsedNoteWithArrow() {
        if (this.arrowExpander != null) {
            this.arrowExpander.setVisibility(this.contentIsOverflowing() ? 0 : 8);
            this.arrowExpander.setScaleY(1.0f);
        }
        this.fade.setVisibility(this.contentIsOverflowing() ? 0 : 4);
    }

    private void runOnMainThread(Runnable action) {
        if (Looper.myLooper() == Looper.getMainLooper()) {
            action.run();
        } else {
            this.lockableScrollView.post(action);
        }
    }
}

