/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.content.Context;
import android.webkit.JavascriptInterface;
import android.webkit.WebView;
import io.intercom.android.sdk.actions.Actions;
import io.intercom.android.sdk.activities.IntercomArticleActivity;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.WebViewConversationAction;
import io.intercom.android.sdk.lightbox.LightBoxActivity;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.state.State;
import io.intercom.android.sdk.store.Store;
import io.intercom.com.google.gson.Gson;
import java.util.Map;

public class WebViewHostWrapper {
    private final ConversationContentPresenter.Host host;
    private final WebView webView;
    private final Gson gson;
    private final Store<State> store;

    WebViewHostWrapper(ConversationContentPresenter.Host host, WebView webView, Gson gson, Store<State> store) {
        this.host = host;
        this.webView = webView;
        this.gson = gson;
        this.store = store;
    }

    @JavascriptInterface
    public void handleAction(String actionJson) {
        final WebViewConversationAction action = (WebViewConversationAction)this.gson.fromJson(actionJson, WebViewConversationAction.class);
        switch (action.getType()) {
            case "CONVERSATION_CHANGED": {
                String conversationJson = this.gson.toJson(action.getValue().get("conversation"));
                final Conversation conversation = ((Conversation.Builder)this.gson.fromJson(conversationJson, Conversation.Builder.class)).build();
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        if (!WebViewHostWrapper.this.host.getConversationId().isEmpty()) {
                            WebViewHostWrapper.this.store.dispatch(Actions.fetchConversationSuccess(conversation));
                        }
                        if (WebViewHostWrapper.this.host.getConversationId().isEmpty() && !conversation.getParts().isEmpty()) {
                            WebViewHostWrapper.this.host.onConversationCreated(conversation);
                        } else {
                            WebViewHostWrapper.this.host.onConversationUpdated(conversation);
                        }
                    }
                });
                break;
            }
            case "IMAGE_CLICKED": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        String imageUrl = (String)action.getValue().get("src");
                        Map rect = (Map)action.getValue().get("rect");
                        if (imageUrl != null && rect != null && rect.containsKey("width") && rect.containsKey("height")) {
                            Double width = (Double)rect.get("width");
                            Double height = (Double)rect.get("height");
                            if (width != null && height != null) {
                                Context context = WebViewHostWrapper.this.webView.getContext();
                                context.startActivity(LightBoxActivity.imageIntent(context, imageUrl, false, width.intValue(), height.intValue()));
                            }
                        }
                    }
                });
                break;
            }
            case "ARTICLE_CARD_CLICKED": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        String articleId = (String)action.getValue().get("articleId");
                        if (articleId != null) {
                            Context context = WebViewHostWrapper.this.webView.getContext();
                            context.startActivity(IntercomArticleActivity.buildIntent(context, articleId, WebViewHostWrapper.this.host.getConversationId()));
                        }
                    }
                });
                break;
            }
            case "POST_CARD_CLICKED": {
                this.webView.post(new Runnable(){

                    @Override
                    public void run() {
                        WebViewHostWrapper.this.host.onPostCardClicked();
                    }
                });
                break;
            }
        }
    }
}

