/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.animation.Animator;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.content.Context;
import android.util.AttributeSet;
import android.view.animation.DecelerateInterpolator;
import android.widget.ImageView;
import android.widget.LinearLayout;
import io.intercom.android.sdk.conversation.UploadProgressListener;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.views.UploadProgressBar;

public class ProgressLinearLayout
extends LinearLayout
implements UploadProgressListener {
    UploadProgressBar uploadProgressBar;
    ImageView attachmentIcon;
    private final Twig twig = LumberMill.getLogger();

    public ProgressLinearLayout(Context context) {
        this(context, null);
    }

    public ProgressLinearLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setUploadProgressBar(UploadProgressBar uploadProgressBar) {
        this.uploadProgressBar = uploadProgressBar;
    }

    public void setAttachmentIcon(ImageView attachmentIcon) {
        this.attachmentIcon = attachmentIcon;
    }

    @Override
    public void uploadStarted() {
        this.uploadProgressBar.smoothStartAnimation();
    }

    @Override
    public void uploadNotice(final byte percentUploaded) {
        this.twig.internal("progress", "" + percentUploaded);
        this.post(new Runnable(){

            @Override
            public void run() {
                if (ProgressLinearLayout.this.uploadProgressBar != null) {
                    ProgressLinearLayout.this.uploadProgressBar.setProgress(percentUploaded);
                    if (percentUploaded == 90) {
                        ProgressLinearLayout.this.uploadProgressBar.smoothEndAnimation(new Animator.AnimatorListener(){

                            public void onAnimationStart(Animator animation) {
                            }

                            public void onAnimationEnd(Animator animation) {
                                ProgressLinearLayout.this.uploadProgressBar.hideBar();
                                if (ProgressLinearLayout.this.attachmentIcon != null) {
                                    ProgressLinearLayout.this.attachmentIcon.setVisibility(0);
                                    ObjectAnimator animator2 = ObjectAnimator.ofFloat((Object)ProgressLinearLayout.this.attachmentIcon, (String)"alpha", (float[])new float[]{0.0f, 1.0f});
                                    animator2.setDuration(300L);
                                    animator2.setInterpolator((TimeInterpolator)new DecelerateInterpolator());
                                    animator2.start();
                                }
                            }

                            public void onAnimationCancel(Animator animation) {
                            }

                            public void onAnimationRepeat(Animator animation) {
                            }
                        });
                    }
                }
            }
        });
    }

    @Override
    public void uploadStopped() {
        this.uploadProgressBar.hideBar();
    }
}

