/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.utilities;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import io.intercom.android.sdk.Intercom;
import javax.annotation.Nullable;

public class ActivityUtils {
    private static final String PACKAGE_NAME;
    private static final String COMPOSER_PACKAGE_NAME = "io.intercom.android.sdk.composer";
    private static final String COMPOSER_INPUT_PACKAGE_NAME = "io.intercom.android.sdk.input";
    private static final String[] INTERCOM_PACKAGES;

    public static boolean isHostActivity(@Nullable Activity activity) {
        return activity != null && ActivityUtils.isInHostAppPackage(activity.getClass().getName());
    }

    public static boolean isNotActive(Activity activity) {
        return activity.isFinishing() || Build.VERSION.SDK_INT >= 17 && activity.isDestroyed();
    }

    public static boolean isNotActive(Context context) {
        return context instanceof Activity && ActivityUtils.isNotActive((Activity)context);
    }

    private static boolean isInHostAppPackage(String activityName) {
        for (String packageName : INTERCOM_PACKAGES) {
            if (!activityName.startsWith(packageName)) continue;
            return false;
        }
        return true;
    }

    static {
        String tempString = "io.intercom.android.sdk.sdk";
        try {
            String packageName = Intercom.class.getPackage().getName();
            if (packageName != null) {
                tempString = packageName;
            }
        }
        finally {
            PACKAGE_NAME = tempString;
        }
        INTERCOM_PACKAGES = new String[]{PACKAGE_NAME, COMPOSER_PACKAGE_NAME, COMPOSER_INPUT_PACKAGE_NAME};
    }
}

