/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.profile;

import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.net.Uri;
import android.support.annotation.ColorInt;
import android.support.annotation.Nullable;
import android.support.design.widget.AppBarLayout;
import android.support.design.widget.CoordinatorLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.Space;
import android.widget.TextView;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.commons.utilities.TimeProvider;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.models.Avatar;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Location;
import io.intercom.android.sdk.models.SocialAccount;
import io.intercom.android.sdk.profile.ProfilePresenter;
import io.intercom.android.sdk.profile.ProfileToolbarBehavior;
import io.intercom.android.sdk.profile.TeammateProfileToolbarBehavior;
import io.intercom.android.sdk.utilities.AvatarUtils;
import io.intercom.android.sdk.utilities.ImageUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.android.sdk.utilities.LocationFormatter;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.views.ActiveStatePresenter;
import io.intercom.com.bumptech.glide.Glide;
import java.util.Date;

class TeammateProfilePresenter {
    private static final int FADE_DURATION_MS = 150;
    private final Space topSpacer;
    private final Space bottomSpacer;
    private final TextView titleView;
    private final TextView subtitleView;
    private final TextView roleView;
    final TextView locationView;
    private final TextView bioView;
    private final ImageView avatarView;
    private final View activeStateView;
    private final ImageView backgroundImageView;
    private final ProfileToolbarBehavior toolbarBehavior;
    private final LinearLayout socialLayout;
    private final ViewGroup rootLayout;
    private final Provider<AppConfig> appConfigProvider;
    private final ImageButton twitterButton;
    private final ImageButton linkedInButton;
    private final ProfilePresenter profilePresenter;
    Location lastAdminLocation;
    private final ActiveStatePresenter activeStatePresenter;
    private final Runnable timeUpdate = new Runnable(){

        @Override
        public void run() {
            TeammateProfilePresenter.this.locationView.removeCallbacks((Runnable)this);
            Context context = TeammateProfilePresenter.this.locationView.getContext();
            CharSequence locationString = LocationFormatter.getLocationString(context, TeammateProfilePresenter.this.lastAdminLocation, new Date());
            TeammateProfilePresenter.this.setTextAndVisibility(TeammateProfilePresenter.this.locationView, locationString);
            LocationFormatter.postOnNextMinute((View)TeammateProfilePresenter.this.locationView, this, TimeProvider.SYSTEM);
        }
    };

    TeammateProfilePresenter(CoordinatorLayout rootView, @ColorInt int baseColor, ProfilePresenter profilePresenter, Provider<AppConfig> appConfigProvider) {
        this.profilePresenter = profilePresenter;
        this.appConfigProvider = appConfigProvider;
        this.rootLayout = (ViewGroup)rootView.findViewById(R.id.intercom_teammate_profile_container_view);
        this.rootLayout.setBackgroundColor(baseColor);
        this.topSpacer = (Space)this.rootLayout.findViewById(R.id.intercom_avatar_spacer);
        this.bottomSpacer = (Space)this.rootLayout.findViewById(R.id.intercom_bottom_spacer);
        this.titleView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_title);
        this.subtitleView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_subtitle);
        this.roleView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_role);
        this.locationView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_location);
        this.bioView = (TextView)this.rootLayout.findViewById(R.id.intercom_collapsing_bio);
        this.avatarView = (ImageView)this.rootLayout.findViewById(R.id.intercom_collapsing_teammate_avatar);
        this.activeStateView = this.rootLayout.findViewById(R.id.intercom_collapsing_teammate_active_state);
        this.twitterButton = (ImageButton)this.rootLayout.findViewById(R.id.twitter_button);
        this.linkedInButton = (ImageButton)this.rootLayout.findViewById(R.id.linkedin_button);
        this.backgroundImageView = (ImageView)rootView.findViewById(R.id.collapsing_background_image);
        this.socialLayout = (LinearLayout)rootView.findViewById(R.id.social_button_layout);
        this.toolbarBehavior = new TeammateProfileToolbarBehavior(this.rootLayout);
        this.activeStatePresenter = new ActiveStatePresenter();
    }

    ViewGroup getRootLayout() {
        return this.rootLayout;
    }

    ProfileToolbarBehavior getToolbarBehavior() {
        return this.toolbarBehavior;
    }

    private void setSocialAccounts(final SocialAccount twitter, final SocialAccount linkedIn, final Context context) {
        if (SocialAccount.isNull(twitter)) {
            this.twitterButton.setVisibility(8);
        } else {
            this.twitterButton.setVisibility(0);
            this.twitterButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)twitter.getProfileUrl()));
                    IntentUtils.safelyOpenIntent(context, intent);
                }
            });
        }
        if (SocialAccount.isNull(linkedIn)) {
            this.linkedInButton.setVisibility(8);
        } else {
            this.linkedInButton.setVisibility(0);
            this.linkedInButton.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)linkedIn.getProfileUrl()));
                    IntentUtils.safelyOpenIntent(context, intent);
                }
            });
        }
        if (this.linkedInButton.getVisibility() == 8 && this.twitterButton.getVisibility() == 8) {
            this.socialLayout.setVisibility(8);
        } else {
            this.socialLayout.setVisibility(0);
        }
    }

    private void setToolbarBackground(Avatar avatar, int height) {
        String imageUrl = avatar.getImageUrl();
        if (!TextUtils.isEmpty((CharSequence)imageUrl)) {
            Glide.with((Context)this.backgroundImageView.getContext()).load(imageUrl).diskCacheStrategy(ImageUtils.getDiskCacheStrategy(imageUrl)).override(this.rootLayout.getMeasuredWidth(), height).into(this.backgroundImageView);
        }
    }

    void setPresence(LastParticipatingAdmin lastParticipant, CharSequence lastActiveTime, int maxWidth, AppBarLayout appBarLayout, ProfilePresenter.ProfileState profileState, View teamLayout, View titleLayoutCoordinator) {
        int height;
        appBarLayout.removeOnOffsetChangedListener((AppBarLayout.OnOffsetChangedListener)this.toolbarBehavior);
        if (this.rootLayout.getAlpha() < 1.0f) {
            if (this.profilePresenter.isDidShowUnknown()) {
                this.rootLayout.setAlpha(1.0f);
                teamLayout.setAlpha(0.0f);
                appBarLayout.setExpanded(profileState == ProfilePresenter.ProfileState.EXPANDED, true);
                this.profilePresenter.setDidShowUnknown(false);
            } else {
                this.rootLayout.animate().alpha(1.0f).setDuration(150L).start();
                teamLayout.animate().alpha(0.0f).setDuration(150L).start();
            }
        }
        Phrase.from((View)this.titleView, R.string.intercom_teammate_from_company).put("name", lastParticipant.getFirstName()).put("company", this.appConfigProvider.get().getName()).into(this.titleView);
        this.setTeammateSubtitle(lastActiveTime);
        AvatarUtils.loadAvatarIntoView(lastParticipant.getAvatar(), this.avatarView);
        this.activeStateView.setVisibility(0);
        this.activeStatePresenter.presentState(lastParticipant.isActive(), this.activeStateView);
        this.setTextAndVisibility(this.roleView, lastParticipant.getJobTitle());
        this.lastAdminLocation = lastParticipant.getLocation();
        this.timeUpdate.run();
        this.setTextAndVisibility(this.bioView, lastParticipant.getIntro());
        Context context = this.rootLayout.getContext();
        this.setSocialAccounts(lastParticipant.getTwitter(), lastParticipant.getLinkedIn(), context);
        if (maxWidth == 0) {
            maxWidth = ScreenUtils.getScreenDimensions((Context)context).x;
        }
        int widthSpec = View.MeasureSpec.makeMeasureSpec((int)maxWidth, (int)0x40000000);
        this.rootLayout.measure(widthSpec, 0);
        titleLayoutCoordinator.getLayoutParams().height = height = this.rootLayout.getMeasuredHeight();
        titleLayoutCoordinator.requestLayout();
        this.backgroundImageView.getLayoutParams().height = height;
        Resources resources = context.getResources();
        this.rootLayout.getLayoutParams().height = resources.getDimensionPixelSize(R.dimen.intercom_toolbar_height);
        this.rootLayout.requestLayout();
        this.profilePresenter.applyOffsetChangedListener(this.toolbarBehavior);
        this.setToolbarBackground(lastParticipant.getAvatar(), height);
    }

    void setTextAndVisibility(TextView textView, CharSequence text) {
        if (TextUtils.isEmpty((CharSequence)text)) {
            textView.setVisibility(8);
        } else {
            textView.setVisibility(0);
            textView.setText(text);
            this.topSpacer.setVisibility(0);
            this.bottomSpacer.setVisibility(0);
        }
    }

    void setTeammateSubtitle(@Nullable CharSequence subtitle) {
        this.subtitleView.setText(subtitle);
    }

    void stopUpdatingTime() {
        this.locationView.removeCallbacks(this.timeUpdate);
    }
}

