/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.models;

import io.intercom.android.sdk.blocks.models.Author;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.commons.utilities.CollectionUtils;
import io.intercom.android.sdk.models.Card;
import io.intercom.android.sdk.models.ReactionReply;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class Link {
    public static final String ARTICLE_TYPE = "educate.article";
    private final String id;
    private final long createdAt;
    private final long updatedAt;
    private final Card card;
    private final List<Block> blocks;
    private final ReactionReply reactionReply;

    Link(Builder builder) {
        this.id = builder.id == null ? UUID.randomUUID().toString() : builder.id;
        this.createdAt = builder.created_at;
        this.updatedAt = builder.updated_at;
        this.blocks = new ArrayList<Block>(CollectionUtils.capacityFor(builder.blocks));
        if (builder.blocks != null) {
            for (Block.Builder blockBuilder : builder.blocks) {
                this.blocks.add(blockBuilder.build());
            }
        }
        this.reactionReply = builder.reactions_reply == null ? ReactionReply.NULL : builder.reactions_reply.build();
        this.card = builder.card == null ? new Card.Builder().build() : builder.card.build();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        if (this.createdAt != link.createdAt) {
            return false;
        }
        if (this.updatedAt != link.updatedAt) {
            return false;
        }
        if (this.id != null ? !this.id.equals(link.id) : link.id != null) {
            return false;
        }
        if (this.card != null ? !this.card.equals(link.card) : link.card != null) {
            return false;
        }
        if (this.blocks != null ? !this.blocks.equals(link.blocks) : link.blocks != null) {
            return false;
        }
        return this.reactionReply != null ? this.reactionReply.equals(link.reactionReply) : link.reactionReply == null;
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (int)(this.createdAt ^ this.createdAt >>> 32);
        result = 31 * result + (int)(this.updatedAt ^ this.updatedAt >>> 32);
        result = 31 * result + (this.card != null ? this.card.hashCode() : 0);
        result = 31 * result + (this.blocks != null ? this.blocks.hashCode() : 0);
        result = 31 * result + (this.reactionReply != null ? this.reactionReply.hashCode() : 0);
        return result;
    }

    public String getId() {
        return this.id;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public long getUpdatedAt() {
        return this.updatedAt;
    }

    public List<Block> getBlocks() {
        return this.blocks;
    }

    public ReactionReply getReactionReply() {
        return this.reactionReply;
    }

    public String getTitle() {
        return this.card.getTitle();
    }

    public String getText() {
        return this.card.getText();
    }

    public String getType() {
        return this.card.getType();
    }

    public String getDescription() {
        return this.card.getDescription();
    }

    public Author getAuthor() {
        return this.card.getAuthor();
    }

    public static final class Builder {
        String id;
        long created_at;
        long updated_at;
        Card.Builder card;
        List<Block.Builder> blocks;
        ReactionReply.Builder reactions_reply;

        public Link build() {
            return new Link(this);
        }
    }
}

