/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.views;

import android.content.Context;
import android.support.v4.content.ContextCompat;
import android.view.View;
import io.intercom.android.sdk.Provider;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.views.ActiveStateDrawable;

public class ActiveStatePresenter {
    private final Provider<AppConfig> appConfigProvider;

    public ActiveStatePresenter(Provider<AppConfig> appConfigProvider) {
        this.appConfigProvider = appConfigProvider;
    }

    public void presentState(boolean isActive, View view) {
        int stateColor = ContextCompat.getColor((Context)view.getContext(), (int)(isActive ? R.color.intercom_active_state : R.color.intercom_away_state));
        int strokeColor = this.appConfigProvider.get().getBaseColor();
        float strokeWidth = 1.0f * view.getResources().getDisplayMetrics().density;
        BackgroundUtils.setBackground(view, new ActiveStateDrawable(stateColor, strokeColor, strokeWidth));
    }
}

