/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation.composer.galleryinput;

import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.intercom.input.gallery.GalleryImage;
import com.intercom.input.gallery.GalleryInputDataSource;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.conversation.composer.galleryinput.Debouncer;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.GifResponse;
import io.intercom.retrofit2.Call;
import io.intercom.retrofit2.Callback;
import io.intercom.retrofit2.Response;
import java.util.ArrayList;
import java.util.List;

class GifInputDataSource
implements GalleryInputDataSource {
    private static final long DEBOUNCE_DELAY_MS = 300L;
    private final Api api;
    private final Debouncer debouncer = new Debouncer();
    private final MetricsStore metricStore;
    private final MetricFactory metricFactory;
    private GalleryInputDataSource.Listener listener;
    private boolean loading;
    private int currentCount = 0;
    @Nullable
    private String lastQuery;

    GifInputDataSource(Api api, MetricsStore metricsStore, MetricFactory metricFactory) {
        this.api = api;
        this.metricStore = metricsStore;
        this.metricFactory = metricFactory;
    }

    public int getPermissionStatus() {
        return 0;
    }

    public void requestPermission() {
    }

    public void setListener(GalleryInputDataSource.Listener listener) {
        this.listener = listener;
    }

    public void getImages(int offset, @Nullable String query) {
        this.loading = true;
        this.lastQuery = query;
        if (TextUtils.isEmpty((CharSequence)query)) {
            this.loadDefaultGifs();
        } else {
            this.searchGifs(query);
        }
    }

    private void loadDefaultGifs() {
        this.api.fetchDefaultGifs(new Callback<GifResponse>(){

            public void onResponse(Call<GifResponse> call, Response<GifResponse> response) {
                List images = GifInputDataSource.this.getImagesFromResponse(((GifResponse)response.body()).results());
                GifInputDataSource.this.loading = false;
                GifInputDataSource.this.listener.onSuccess(images);
            }

            public void onFailure(Call<GifResponse> call, Throwable t) {
                GifInputDataSource.this.loading = false;
                GifInputDataSource.this.listener.onError();
            }
        });
    }

    private void searchGifs(final String query) {
        this.metricStore.track(this.metricFactory.searchedGifInput(query));
        this.debouncer.call(new Runnable(){

            @Override
            public void run() {
                GifInputDataSource.this.api.fetchGifs(query, new Callback<GifResponse>(){

                    public void onResponse(Call<GifResponse> call, Response<GifResponse> response) {
                        GifInputDataSource.this.loading = false;
                        if (!query.equals(GifInputDataSource.this.lastQuery)) {
                            return;
                        }
                        List images = GifInputDataSource.this.getImagesFromResponse(((GifResponse)response.body()).results());
                        GifInputDataSource.this.listener.onSuccess(images);
                    }

                    public void onFailure(Call<GifResponse> call, Throwable t) {
                        GifInputDataSource.this.loading = false;
                        GifInputDataSource.this.listener.onError();
                    }
                });
            }
        }, 300L);
    }

    private List<GalleryImage> getImagesFromResponse(List<Block> results) {
        this.currentCount = results.size();
        ArrayList<GalleryImage> images = new ArrayList<GalleryImage>(this.currentCount);
        for (Block result : results) {
            images.add(new GalleryImage.Builder().withPath(result.getUrl()).withPreviewPath(result.getPreviewUrl()).withAttribution(result.getAttribution()).withImageHeight(result.getHeight()).withImageWidth(result.getWidth()).build());
        }
        return images;
    }

    public int getCount() {
        return this.currentCount;
    }

    public boolean isLoading() {
        return this.loading;
    }
}

