/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.conversation;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.View;
import android.webkit.WebView;
import com.intercom.input.gallery.GalleryImage;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.blocks.models.Block;
import io.intercom.android.sdk.conversation.ConversationContentPresenter;
import io.intercom.android.sdk.conversation.events.AdminIsTypingEvent;
import io.intercom.android.sdk.conversation.events.AdminTypingEndedEvent;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.events.ConversationEvent;
import io.intercom.android.sdk.models.events.NewConversationEvent;
import io.intercom.android.sdk.models.events.ReplyEvent;
import java.util.List;

class WebViewConversationContentPresenter
implements ConversationContentPresenter {
    private static final String WEB_PAGE_URL = "https://js.intercomcdn.com/mobile.html";
    private final WebView webView;
    private final View container;

    WebViewConversationContentPresenter(WebView webView, View container) {
        this.webView = webView;
        this.container = container;
    }

    @Override
    @SuppressLint(value={"SetJavaScriptEnabled"})
    public void setup() {
        this.container.setVisibility(0);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.loadUrl(WEB_PAGE_URL);
        this.webView.setBackgroundResource(R.color.intercom_full_transparent_full_white);
    }

    @Override
    public void smoothScrollToTop() {
        this.scrollToTop();
    }

    @Override
    public void scrollToTop() {
        this.webView.scrollTo(0, 0);
    }

    @Override
    public void scrollToBottom() {
        this.webView.scrollTo(0, this.webView.getContentHeight());
    }

    @Override
    public boolean isAtBottom() {
        return this.webView.getScrollY() + this.webView.getHeight() >= this.webView.getContentHeight();
    }

    @Override
    public void onProfileScrolled() {
    }

    @Override
    public void onGlobalLayout() {
    }

    @Override
    public void onNewPartReceived() {
    }

    @Override
    public void showErrorView() {
    }

    @Override
    public void showLoadingView() {
    }

    @Override
    public void showContentView() {
    }

    @Override
    public void onAdminStartedTyping(AdminIsTypingEvent event, Context context) {
    }

    @Override
    public void onAdminStoppedTyping(AdminTypingEndedEvent event) {
    }

    @Override
    public void fetchConversation(String conversationId) {
    }

    @Override
    public void onPartClicked(Part part) {
    }

    @Override
    public void sendPart(List<Block.Builder> blockBuilders, Part part) {
    }

    @Override
    public Part addSendingPart(List<Block> blocks) {
        return new Part();
    }

    @Override
    public void uploadImage(List<Block> blocks, GalleryImage galleryImage) {
    }

    @Override
    public void onNewConversation(NewConversationEvent event) {
    }

    @Override
    public void onReplyDelivered(ReplyEvent event) {
    }

    @Override
    public void onConversationFetched(ConversationEvent event) {
    }

    @Override
    public void cleanup() {
    }
}

