/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ArgbEvaluator;
import android.animation.TimeInterpolator;
import android.animation.TypeEvaluator;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.view.View;
import android.view.animation.OvershootInterpolator;
import android.view.inputmethod.InputMethodManager;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.conversation.ConversationFragment;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.inbox.InboxFragment;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.Conversation;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.state.InboxState;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ActivityFinisher;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.views.StatusBarThemer;
import java.util.List;

public class IntercomMessengerActivity
extends IntercomBaseActivity
implements InboxFragment.Listener,
ConversationFragment.Listener {
    @VisibleForTesting
    static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    @VisibleForTesting
    static final String PARCEL_INITIAL_MESSAGE = "parcel_initial_message";
    @VisibleForTesting
    ValueAnimator colorAnimation;
    static final String SHOW_INBOX = "showInbox";
    static final String LAST_PARTICIPANT = "last_participant";
    private InboxFragment inboxFragment;
    private View containerView;
    View background;
    private MetricFactory metricFactory;
    private MetricsStore metricStore;
    private ActivityFinisher activityFinisher;
    private boolean isTwoPane;
    private final Twig twig = LumberMill.getLogger();

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_messenger_activity_layout);
        this.isTwoPane = this.getResources().getBoolean(R.bool.intercom_is_two_pane);
        this.inboxFragment = InboxFragment.newInstance(this.isTwoPane);
        this.containerView = this.findViewById(R.id.messenger_container);
        if (this.containerView != null) {
            this.containerView.setVisibility(8);
        }
        this.getFragmentManager().executePendingTransactions();
        this.showMessenger();
        Injector injector = Injector.get();
        this.activityFinisher = injector.getActivityFinisher();
        this.activityFinisher.register((Activity)this);
        UserIdentity userIdentity = injector.getUserIdentity();
        this.metricFactory = new MetricFactory(userIdentity);
        this.metricStore = injector.getMetricsStore();
    }

    private int getScreenHeight() {
        return this.findViewById(0x1020002).getMeasuredHeight();
    }

    protected void onDestroy() {
        this.activityFinisher.unregister((Activity)this);
        super.onDestroy();
    }

    private void showMessenger() {
        Bundle data = this.getIntent().getExtras();
        String conversationId = "";
        String initialMessage = "";
        LastParticipatingAdmin lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        boolean shouldShowInbox = false;
        if (data != null) {
            data.setClassLoader(Part.class.getClassLoader());
            conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
            initialMessage = data.getString(PARCEL_INITIAL_MESSAGE, "");
            shouldShowInbox = data.getBoolean(SHOW_INBOX);
            if (data.containsKey(LAST_PARTICIPANT)) {
                lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
            }
        }
        if (this.isTwoPane) {
            boolean openingComposer;
            this.displayFragment(this.inboxFragment, InboxFragment.class.getName(), false);
            boolean openingSpecificConversation = !conversationId.isEmpty();
            boolean bl = openingComposer = !initialMessage.isEmpty();
            if (openingSpecificConversation || openingComposer) {
                this.displayConversation(conversationId, lastParticipatingAdmin, false, false, initialMessage);
            }
        } else if (shouldShowInbox) {
            this.displayFragment(this.inboxFragment, InboxFragment.class.getName(), false);
        } else {
            this.displayConversation(conversationId, lastParticipatingAdmin, false, false, initialMessage);
        }
        this.background = this.getWindow().getDecorView();
        BackgroundUtils.animateBackground(ContextCompat.getColor((Context)this, (int)17170445), ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black), 200, this.background, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.background.post(new Runnable(){

                    @Override
                    public void run() {
                        IntercomMessengerActivity.this.animateSdkWindowIn();
                    }
                });
            }
        });
    }

    private void displayFragment(Fragment frag, String tag, boolean addToBackStack) {
        this.twig.internal("frag", "displaying " + frag);
        FragmentTransaction transaction = this.getSupportFragmentManager().beginTransaction();
        int fragmentId = frag instanceof ConversationFragment && this.isTwoPane ? R.id.conversation_fragment : R.id.inbox_fragment;
        transaction.replace(fragmentId, frag, tag);
        if (addToBackStack) {
            this.twig.internal("frag", "adding " + frag + " to the back stack");
            transaction.addToBackStack(tag);
        }
        transaction.commitAllowingStateLoss();
    }

    public void onBackPressed() {
        ConversationFragment fragment = this.getExistingConversationFragment();
        if (fragment != null && fragment.shouldHandleOnBackPressed()) {
            fragment.handleOnBackPressed();
        } else {
            this.applyBackOrCloseMessenger();
        }
    }

    private void applyBackOrCloseMessenger() {
        if (this.getSupportFragmentManager().getBackStackEntryCount() == 0) {
            this.metricStore.track(this.metricFactory.closedMessengerBackButton());
            this.closeMessenger();
        } else {
            this.trackMoveToConversationListMetric();
            super.onBackPressed();
        }
    }

    private void trackMoveToConversationListMetric() {
        ConversationFragment fragment = this.getExistingConversationFragment();
        if (fragment != null) {
            String conversationId = fragment.getConversationId();
            if (TextUtils.isEmpty((CharSequence)conversationId)) {
                this.metricStore.track(this.metricFactory.openConversationsListFromNewConversation());
            } else {
                this.metricStore.track(this.metricFactory.openConversationsListFromConversation(conversationId));
            }
        }
    }

    ConversationFragment getExistingConversationFragment() {
        String tag = ConversationFragment.class.getName();
        return (ConversationFragment)this.getSupportFragmentManager().findFragmentByTag(tag);
    }

    @Override
    public void onConversationsLoaded(List<Conversation> conversations, InboxState.Status status) {
        boolean hasConversations;
        if (!this.isTwoPane || status != InboxState.Status.SUCCESS || this.getExistingConversationFragment() != null) {
            return;
        }
        boolean bl = hasConversations = !conversations.isEmpty();
        if (hasConversations) {
            this.onConversationSelected(conversations.get(0));
        } else if (Injector.get().getAppConfigProvider().get().isInboundMessages()) {
            this.onComposerSelected();
        }
    }

    @Override
    public void onConversationSelected(Conversation conversation) {
        LastParticipatingAdmin lastParticipatingAdmin = conversation.getLastParticipatingAdmin();
        if (LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            lastParticipatingAdmin = LastParticipatingAdmin.NONE;
        }
        this.displayConversation(conversation.getId(), lastParticipatingAdmin, conversation.isRead(), !this.isTwoPane, "");
        this.metricStore.track(this.metricFactory.openConversationFromConversationList(conversation.getId()));
    }

    @Override
    public void onComposerSelected() {
        this.displayConversation("", LastParticipatingAdmin.NONE, true, !this.isTwoPane, "");
        this.metricStore.track(this.metricFactory.newConversationFromComposeButton());
    }

    private void displayConversation(String conversationId, LastParticipatingAdmin participant, boolean isRead, boolean addToBackStack, String initialMessage) {
        ConversationFragment fragment = ConversationFragment.newInstance(conversationId, participant, isRead, this.isTwoPane, initialMessage);
        this.displayFragment(fragment, ConversationFragment.class.getName(), addToBackStack);
    }

    void animateSdkWindowIn() {
        this.containerView.setVisibility(0);
        this.containerView.setY((float)this.getScreenHeight());
        this.containerView.animate().y(0.0f).setInterpolator((TimeInterpolator)new OvershootInterpolator(0.6f)).setDuration(350L).setListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.hideBackgroundColor();
                ConversationFragment fragment = IntercomMessengerActivity.this.getExistingConversationFragment();
                if (fragment != null) {
                    fragment.sdkWindowFinishedAnimating();
                }
            }
        }).start();
    }

    private void closeMessenger() {
        this.hideKeyboard();
        this.showBackgroundColour();
        this.containerView.animate().y((float)this.getWindow().getDecorView().getHeight()).setInterpolator((TimeInterpolator)new OvershootInterpolator()).setDuration(600L).start();
        this.fadeOutBackground();
    }

    private void hideKeyboard() {
        View focusedView = this.getCurrentFocus();
        if (focusedView != null) {
            InputMethodManager inputManager = (InputMethodManager)this.getSystemService("input_method");
            inputManager.hideSoftInputFromWindow(focusedView.getWindowToken(), 0);
        }
    }

    private void fadeOutBackground() {
        int colorTo = ContextCompat.getColor((Context)this, (int)17170445);
        int colorFrom = ContextCompat.getColor((Context)this, (int)R.color.intercom_transparent_black);
        this.colorAnimation = ValueAnimator.ofObject((TypeEvaluator)new ArgbEvaluator(), (Object[])new Object[]{colorFrom, colorTo});
        this.colorAnimation.setDuration(300L);
        this.colorAnimation.setStartDelay(100L);
        this.colorAnimation.addUpdateListener(new ValueAnimator.AnimatorUpdateListener(){

            public void onAnimationUpdate(ValueAnimator animator2) {
                IntercomMessengerActivity.this.background.setBackgroundColor(((Integer)animator2.getAnimatedValue()).intValue());
            }
        });
        this.colorAnimation.addListener((Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                IntercomMessengerActivity.this.finish();
                IntercomMessengerActivity.this.overridePendingTransition(0, 0);
            }
        });
        this.colorAnimation.start();
    }

    @Override
    public void onToolbarCloseClicked() {
        this.metricStore.track(this.metricFactory.closedMessengerCloseButton());
        this.closeMessenger();
    }

    @Override
    public void onBackToInboxClicked() {
        if (this.hasLoadedFragment(InboxFragment.class.getName())) {
            this.applyBackOrCloseMessenger();
        } else {
            this.trackMoveToConversationListMetric();
            this.displayFragment(this.inboxFragment, InboxFragment.class.getName(), false);
        }
    }

    private void showBackgroundColour() {
        this.background.setBackgroundResource(R.color.intercom_transparent_black);
    }

    void hideBackgroundColor() {
        this.background.setBackgroundResource(R.color.intercom_full_transparent_full_black);
    }

    @Override
    public void setStatusBarColor() {
        StatusBarThemer.setStatusBarColor(this.getWindow());
    }

    public static Intent openInbox(Context context) {
        return new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, true);
    }

    public static Intent openComposer(Context context, String initialMessage) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)initialMessage)) {
            intent.putExtra(PARCEL_INITIAL_MESSAGE, initialMessage);
        }
        return intent;
    }

    public static Intent openConversation(Context context, String conversationId, LastParticipatingAdmin lastParticipatingAdmin) {
        Intent intent = new Intent(context, IntercomMessengerActivity.class).setFlags(0x10000000).putExtra(SHOW_INBOX, false);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        if (!LastParticipatingAdmin.isNull(lastParticipatingAdmin)) {
            intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        }
        intent.setExtrasClassLoader(LastParticipatingAdmin.class.getClassLoader());
        return intent;
    }

    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.containerView.setY(0.0f);
        this.containerView.getLayoutParams().height = -1;
    }

    private boolean hasLoadedFragment(String fragmentTag) {
        return this.getSupportFragmentManager().findFragmentByTag(fragmentTag) != null;
    }
}

