/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.push.PushReceiverDelegate;

public class IntercomPushBroadcastReceiver
extends BroadcastReceiver {
    static final String INTERCOM_PUSH_OPENED = "io.intercom.android.sdk.INTERCOM_PUSH_OPENED";
    static final String INTERCOM_PUSH_DISMISSED = "io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED";
    private final PushReceiverDelegate pushReceiverDelegate = new PushReceiverDelegate();

    public void onReceive(Context context, Intent intent) {
        Injector.init((Application)context.getApplicationContext());
        Injector injector = Injector.get();
        UserIdentity userIdentity = injector.getUserIdentity();
        MetricFactory metricFactory = new MetricFactory(userIdentity);
        MetricsStore metricStore = injector.getMetricsStore();
        switch (intent.getAction()) {
            case "io.intercom.android.sdk.INTERCOM_PUSH_DISMISSED": {
                this.pushReceiverDelegate.trackDismiss(intent, userIdentity, metricStore, metricFactory);
                break;
            }
            default: {
                Api api = injector.getApi();
                this.pushReceiverDelegate.handlePushTap(context, intent, api, userIdentity, metricStore, metricFactory);
            }
        }
    }
}

