/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.blocks;

import android.content.Context;
import android.content.Intent;
import android.graphics.PorterDuff;
import android.net.Uri;
import android.os.Handler;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.blocks.StyleType;
import io.intercom.android.sdk.blocks.VideoProvider;
import io.intercom.android.sdk.blocks.blockInterfaces.VideoBlock;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.LumberMill;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.ActivityUtils;
import io.intercom.android.sdk.utilities.BackgroundUtils;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.ColorUtils;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.com.bumptech.glide.Glide;
import io.intercom.com.bumptech.glide.load.resource.drawable.GlideDrawable;
import io.intercom.com.bumptech.glide.request.RequestListener;
import io.intercom.com.bumptech.glide.request.target.Target;
import io.intercom.okhttp3.Call;
import io.intercom.okhttp3.Callback;
import io.intercom.okhttp3.Response;
import java.io.IOException;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class Video
implements VideoBlock {
    private static final int PLAY_BUTTON_DIAMETER_DP = 48;
    final Context context;
    private final StyleType style;
    private final Api.Provider apiProvider;
    private final AppConfig.Provider appConfigProvider;
    private final Twig twig = LumberMill.getLogger();

    Video(Context context, StyleType style, Api.Provider apiProvider, AppConfig.Provider appConfigProvider) {
        this.context = context;
        this.style = style;
        this.apiProvider = apiProvider;
        this.appConfigProvider = appConfigProvider;
    }

    public View addVideo(String videoUrl, VideoProvider provider, String id2, boolean isFirstObject, boolean isLastObject, ViewGroup parent) {
        RelativeLayout rootView = this.getBaseLayout();
        ImageView videoImageView = this.getVideoImageView();
        ImageView playButton = this.getPlayButtonView();
        rootView.addView((View)videoImageView);
        rootView.addView((View)playButton);
        int color2 = this.appConfigProvider.getAppConfig().getBaseColor();
        if (this.style == StyleType.POST) {
            color2 = ColorUtils.lightenColor(color2);
        }
        playButton.setColorFilter(color2, PorterDuff.Mode.SRC_ATOP);
        this.fetchThumbnail(provider, id2, videoImageView, playButton);
        BlockUtils.setLayoutMarginsAndGravity((View)rootView, 3, isLastObject);
        return rootView;
    }

    @VisibleForTesting
    void fetchThumbnail(VideoProvider provider, final String id2, final ImageView videoImageView, final ImageView playButton) {
        switch (provider) {
            case WISTIA: {
                this.apiProvider.getApi().getVideo("http://fast.wistia.com/oembed?url=http://home.wistia.com/medias/" + id2, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        Video.this.setFailedImage(videoImageView);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            final String wistiaVideoUrl = "http://fast.wistia.net/embed/iframe/" + id2;
                            JSONObject video = new JSONObject();
                            try {
                                video = new JSONObject(response.body().string());
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                Video.this.twig.internal("ErrorObject", "Couldn't read response body: " + e.getMessage());
                            }
                            finally {
                                response.body().close();
                            }
                            String wistiaThumbnailUrl = video.optString("thumbnail_url");
                            int end = wistiaThumbnailUrl.indexOf("?image_crop_resized");
                            if (end > 0) {
                                wistiaThumbnailUrl = wistiaThumbnailUrl.substring(0, end);
                            }
                            Handler mainHandler = new Handler(Video.this.context.getMainLooper());
                            final String finalWistiaThumbnailUrl = wistiaThumbnailUrl;
                            Runnable myRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(videoImageView, wistiaVideoUrl, finalWistiaThumbnailUrl, playButton);
                                }
                            };
                            mainHandler.post(myRunnable);
                        } else {
                            Video.this.setFailedImage(videoImageView);
                        }
                    }
                });
                break;
            }
            case YOUTUBE: {
                this.createThumbnail(videoImageView, "http://www.youtube.com/watch?v=" + id2, "http://img.youtube.com/vi/" + id2 + "/default.jpg", playButton);
                break;
            }
            case VIMEO: {
                String vimeoVideoUrl = "http://vimeo.com/api/v2/video/" + id2 + ".json";
                this.apiProvider.getApi().getVideo(vimeoVideoUrl, new Callback(){

                    public void onFailure(Call call, IOException e) {
                        Video.this.setFailedImage(videoImageView);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void onResponse(Call call, Response response) throws IOException {
                        if (response.isSuccessful()) {
                            JSONObject video = new JSONObject();
                            try {
                                JSONArray jArray = new JSONArray(response.body().string());
                                video = jArray.optJSONObject(0);
                            }
                            catch (JSONException e) {
                                e.printStackTrace();
                            }
                            catch (IOException e) {
                                Video.this.twig.internal("Couldn't read response body: " + e.getMessage());
                            }
                            finally {
                                response.body().close();
                            }
                            final String vimeoThumbnailUrl = video.optString("thumbnail_large");
                            Handler mainHandler = new Handler(Video.this.context.getMainLooper());
                            Runnable myRunnable = new Runnable(){

                                @Override
                                public void run() {
                                    Video.this.createThumbnail(videoImageView, "http://player.vimeo.com/video/" + id2, vimeoThumbnailUrl, playButton);
                                }
                            };
                            mainHandler.post(myRunnable);
                        }
                    }
                });
                break;
            }
        }
    }

    void createThumbnail(final ImageView imageView, final String videoUrl, String thumbnailUrl, final ImageView playButton) {
        if (ActivityUtils.isNotActive(this.context)) {
            return;
        }
        Glide.with((Context)this.context).load(thumbnailUrl).placeholder(R.drawable.intercom_video_thumbnail_fallback).error(R.drawable.intercom_video_thumbnail_fallback).listener((RequestListener)new RequestListener<String, GlideDrawable>(){

            public boolean onException(Exception e, String model, Target<GlideDrawable> target, boolean isFirstResource) {
                playButton.setVisibility(8);
                return false;
            }

            public boolean onResourceReady(GlideDrawable resource, String model, Target<GlideDrawable> target, boolean isFromMemoryCache, boolean isFirstResource) {
                int colour = ContextCompat.getColor((Context)Video.this.context, (int)R.color.intercom_semi_transparent);
                imageView.setColorFilter(colour, PorterDuff.Mode.DARKEN);
                playButton.setVisibility(0);
                return false;
            }
        }).into(imageView);
        if (this.style != StyleType.CHAT_FULL) {
            imageView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View view) {
                    Uri uri = Uri.parse((String)videoUrl);
                    Intent intent = new Intent("android.intent.action.VIEW", uri);
                    intent.setFlags(0x10000000);
                    IntentUtils.safelyOpenIntent(Video.this.context, intent);
                }
            });
        }
    }

    void setFailedImage(final ImageView imageView) {
        imageView.post(new Runnable(){

            @Override
            public void run() {
                BackgroundUtils.setBackground((View)imageView, ContextCompat.getDrawable((Context)Video.this.context, (int)R.drawable.intercom_video_thumbnail_fallback));
            }
        });
    }

    private RelativeLayout getBaseLayout() {
        RelativeLayout base = new RelativeLayout(this.context);
        BlockUtils.createLayoutParams((View)base, -2, -2);
        BlockUtils.setDefaultMarginBottom((View)base);
        return base;
    }

    private ImageView getPlayButtonView() {
        int diameterPx = ScreenUtils.dpToPx((float)48.0f, (Context)this.context);
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(diameterPx, diameterPx);
        params.addRule(13);
        ImageView playButton = new ImageView(this.context);
        playButton.setLayoutParams((ViewGroup.LayoutParams)params);
        playButton.setScaleType(ImageView.ScaleType.CENTER);
        playButton.setImageResource(R.drawable.intercom_play_arrow);
        playButton.setBackgroundResource(R.drawable.intercom_solid_circle);
        playButton.setVisibility(8);
        return playButton;
    }

    private ImageView getVideoImageView() {
        RelativeLayout.LayoutParams params = new RelativeLayout.LayoutParams(-2, -2);
        ImageView videoImage = new ImageView(this.context);
        videoImage.setLayoutParams((ViewGroup.LayoutParams)params);
        videoImage.setAdjustViewBounds(true);
        videoImage.setScaleType(ImageView.ScaleType.FIT_START);
        return videoImage;
    }
}

