/*
 * Decompiled with CFR 0.152.
 */
package com.intercom.composer;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.support.annotation.ColorInt;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.VisibleForTesting;
import android.support.v4.app.Fragment;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.intercom.composer.ComposerHost;
import com.intercom.composer.ComposerView;
import com.intercom.composer.OnInputSelectedListener;
import com.intercom.composer.animation.EditTextLayoutAnimatorInternalListener;
import com.intercom.composer.input.Input;
import com.intercom.composer.input.text.TextInput;
import com.intercom.composer.input.text.listener.OnSendButtonClickedListener;
import com.intercom.composer.pager.ComposerPagerAdapter;
import io.intercom.android.sdk.R;
import java.util.List;

public class ComposerFragment
extends Fragment {
    private static final String KEY_INITIAL_INPUT_IDENTIFIER = "initial_input_identifier";
    private static final String KEY_SHOW_KEYBOARD_FOR_INITIAL_INPUT = "show_keyboard_for_initial_input";
    private static final String KEY_THEME_COLOR = "theme_color";
    @VisibleForTesting
    @Nullable
    ComposerHost composerHost;
    @Nullable
    private OnInputSelectedListener onInputSelectedListener;
    @VisibleForTesting
    ComposerView composerView;
    @Nullable
    String initialInputIdentifier;
    private boolean showKeyboardForInitialInput;
    @ColorInt
    private int themeColor;
    @VisibleForTesting
    Input inputToBeRestored;
    private Runnable selectDefaultInputRunnable = new Runnable(){

        @Override
        public void run() {
            ComposerFragment.this.selectDefaultInputOnCreateView();
        }
    };

    public static ComposerFragment newInstance(@Nullable String initialInputIdentifier, boolean showKeyboardForInitialInput, @ColorInt int themeColor) {
        ComposerFragment composerFragment = new ComposerFragment();
        Bundle args = new Bundle();
        args.putString(KEY_INITIAL_INPUT_IDENTIFIER, initialInputIdentifier);
        args.putBoolean(KEY_SHOW_KEYBOARD_FOR_INITIAL_INPUT, showKeyboardForInitialInput);
        args.putInt(KEY_THEME_COLOR, themeColor);
        composerFragment.setArguments(args);
        return composerFragment;
    }

    public void setComposerHost(@NonNull ComposerHost composerHost) {
        this.composerHost = composerHost;
    }

    public void setOnInputSelectedListener(@NonNull OnInputSelectedListener onInputSelectedListener) {
        this.onInputSelectedListener = onInputSelectedListener;
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (context instanceof ComposerHost) {
            this.composerHost = (ComposerHost)context;
        }
        if (context instanceof OnInputSelectedListener) {
            this.onInputSelectedListener = (OnInputSelectedListener)context;
        }
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setRetainInstance(true);
        this.initialInputIdentifier = this.getArguments().getString(KEY_INITIAL_INPUT_IDENTIFIER);
        this.showKeyboardForInitialInput = this.getArguments().getBoolean(KEY_SHOW_KEYBOARD_FOR_INITIAL_INPUT);
        this.themeColor = this.getArguments().getInt(KEY_THEME_COLOR);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.composerView = (ComposerView)inflater.inflate(R.layout.intercom_composer_layout, container, false);
        this.composerView.applyTheme(this.getContext(), this.themeColor);
        List<Input> inputs = this.composerHost.getInputs();
        ComposerPagerAdapter composerPagerAdapter = new ComposerPagerAdapter(this.getChildFragmentManager(), inputs);
        this.composerView.setFragmentManager(this.getChildFragmentManager());
        this.composerView.setInputs(inputs);
        this.composerView.setOnSendButtonClickListener(new OnSendButtonClickedListener(){

            @Override
            public void onSendButtonClicked(CharSequence textToBeSent) {
                Input selectedInput = ComposerFragment.this.composerView.getSelectedInput();
                if (selectedInput instanceof TextInput) {
                    TextInput selectedTextInput = (TextInput)selectedInput;
                    selectedTextInput.sendTextBack(textToBeSent);
                }
            }
        });
        if (this.onInputSelectedListener != null) {
            this.composerView.setInputSelectedListener(this.onInputSelectedListener);
        }
        this.composerView.setComposerPagerAdapter(composerPagerAdapter);
        this.composerView.setEditTextLayoutAnimationListener(new EditTextLayoutAnimatorInternalListener((Activity)this.getActivity()));
        this.composerView.post(this.selectDefaultInputRunnable);
        return this.composerView;
    }

    @VisibleForTesting
    void selectDefaultInputOnCreateView() {
        if (this.inputToBeRestored != null && this.composerView.selectInput(this.inputToBeRestored, false, true)) {
            return;
        }
        List<Input> inputs = this.composerHost.getInputs();
        if (!inputs.isEmpty()) {
            Input input = this.findInputForIdentifier(this.initialInputIdentifier);
            if (input == null) {
                input = inputs.get(0);
            }
            this.composerView.selectInput(input, this.showKeyboardForInitialInput, true);
        }
    }

    public void onDestroyView() {
        this.inputToBeRestored = this.composerView.getSelectedInput();
        super.onDestroyView();
    }

    public void onDestroy() {
        if (this.composerView != null) {
            this.composerView.onDestroy();
        }
        super.onDestroy();
    }

    public boolean onBackPressed() {
        return this.composerView.onBackPressed();
    }

    @Nullable
    public Input findInputForIdentifier(@Nullable String identifier) {
        if (TextUtils.isEmpty((CharSequence)identifier)) {
            return null;
        }
        for (Input input : this.composerHost.getInputs()) {
            if (!input.getUniqueIdentifier().equals(identifier)) continue;
            return input;
        }
        return null;
    }

    @Nullable
    public Input getLastSelectedInput() {
        return this.composerView.getSelectedInput();
    }

    public void selectInput(String identifier, boolean showKeyboard) {
        Input input = this.findInputForIdentifier(identifier);
        if (input != null) {
            this.composerView.selectInput(input, showKeyboard, true);
        }
    }

    public int getTextInputHeight() {
        return this.composerView.getTextInputHeight();
    }

    public boolean isOpen() {
        Input input = this.getLastSelectedInput();
        return this.hasSelectedInput(input) && this.isNotTextInput(input);
    }

    private boolean isNotTextInput(Input input) {
        return !(input instanceof TextInput);
    }

    private boolean hasSelectedInput(Input input) {
        return input != null;
    }
}

