/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.com.bumptech.glide.load.engine.prefill;

import android.graphics.Bitmap;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Log;
import io.intercom.com.bumptech.glide.load.Key;
import io.intercom.com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import io.intercom.com.bumptech.glide.load.engine.cache.MemoryCache;
import io.intercom.com.bumptech.glide.load.engine.prefill.PreFillQueue;
import io.intercom.com.bumptech.glide.load.engine.prefill.PreFillType;
import io.intercom.com.bumptech.glide.load.resource.bitmap.BitmapResource;
import io.intercom.com.bumptech.glide.util.Util;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;

final class BitmapPreFillRunner
implements Runnable {
    private static final String TAG = "PreFillRunner";
    private static final Clock DEFAULT_CLOCK = new Clock();
    static final long MAX_DURATION_MS = 32L;
    static final long INITIAL_BACKOFF_MS = 40L;
    static final int BACKOFF_RATIO = 4;
    static final long MAX_BACKOFF_MS = TimeUnit.SECONDS.toMillis(1L);
    private final BitmapPool bitmapPool;
    private final MemoryCache memoryCache;
    private final PreFillQueue toPrefill;
    private final Clock clock;
    private final Set<PreFillType> seenTypes = new HashSet<PreFillType>();
    private final Handler handler;
    private long currentDelay = 40L;
    private boolean isCancelled;

    public BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue allocationOrder) {
        this(bitmapPool, memoryCache, allocationOrder, DEFAULT_CLOCK, new Handler(Looper.getMainLooper()));
    }

    BitmapPreFillRunner(BitmapPool bitmapPool, MemoryCache memoryCache, PreFillQueue allocationOrder, Clock clock, Handler handler) {
        this.bitmapPool = bitmapPool;
        this.memoryCache = memoryCache;
        this.toPrefill = allocationOrder;
        this.clock = clock;
        this.handler = handler;
    }

    public void cancel() {
        this.isCancelled = true;
    }

    private boolean allocate() {
        long start = this.clock.now();
        while (!this.toPrefill.isEmpty() && !this.isGcDetected(start)) {
            PreFillType toAllocate = this.toPrefill.remove();
            Bitmap bitmap = Bitmap.createBitmap((int)toAllocate.getWidth(), (int)toAllocate.getHeight(), (Bitmap.Config)toAllocate.getConfig());
            if (this.getFreeMemoryCacheBytes() >= Util.getBitmapByteSize(bitmap)) {
                this.memoryCache.put(new UniqueKey(), BitmapResource.obtain(bitmap, this.bitmapPool));
            } else {
                this.addToBitmapPool(toAllocate, bitmap);
            }
            if (!Log.isLoggable((String)TAG, (int)3)) continue;
            Log.d((String)TAG, (String)("allocated [" + toAllocate.getWidth() + "x" + toAllocate.getHeight() + "] " + toAllocate.getConfig() + " size: " + Util.getBitmapByteSize(bitmap)));
        }
        return !this.isCancelled && !this.toPrefill.isEmpty();
    }

    private boolean isGcDetected(long startTimeMs) {
        return this.clock.now() - startTimeMs >= 32L;
    }

    private int getFreeMemoryCacheBytes() {
        return this.memoryCache.getMaxSize() - this.memoryCache.getCurrentSize();
    }

    private void addToBitmapPool(PreFillType toAllocate, Bitmap bitmap) {
        Bitmap fromPool;
        if (this.seenTypes.add(toAllocate) && (fromPool = this.bitmapPool.get(toAllocate.getWidth(), toAllocate.getHeight(), toAllocate.getConfig())) != null) {
            this.bitmapPool.put(fromPool);
        }
        this.bitmapPool.put(bitmap);
    }

    @Override
    public void run() {
        if (this.allocate()) {
            this.handler.postDelayed((Runnable)this, this.getNextDelay());
        }
    }

    private long getNextDelay() {
        long result = this.currentDelay;
        this.currentDelay = Math.min(this.currentDelay * 4L, MAX_BACKOFF_MS);
        return result;
    }

    static class Clock {
        Clock() {
        }

        public long now() {
            return SystemClock.currentThreadTimeMillis();
        }
    }

    private static class UniqueKey
    implements Key {
        private UniqueKey() {
        }

        @Override
        public void updateDiskCacheKey(MessageDigest messageDigest) throws UnsupportedEncodingException {
        }
    }
}

