/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.annotation.SuppressLint;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import io.intercom.android.sdk.logger.IntercomLogger;

public class IntercomPushManager {
    private static final String PREFS_SENDER_ID = "intercom_sender_id";
    public static final String MULTIPLE_NOTIFICATIONS = "multiple_notifications";
    public static final String PUSH_ONLY_ID = "push_only_convo_id";
    public static final String INTERCOM_PUSH_KEY = "intercom_push_key";
    public static final String HOST_APP_INTENT = "host_app_intent";
    public static final String INTERCOM_PUSH_PATH = "intercom_push_notification_path";

    static void startGcmRegistrationService(Context context) {
        Class gcmRegistrationServiceClass = IntercomPushManager.getGcmRegistrationServiceClass();
        Intent intent = new Intent(context, gcmRegistrationServiceClass);
        context.startService(intent);
    }

    static void changeComponentState(int newState, Context context) {
        if (IntercomPushManager.fcmModuleInstalled()) {
            IntercomPushManager.changeFcmComponentState(newState, context);
        } else {
            IntercomPushManager.changeGcmComponentState(newState, context);
        }
    }

    private static void changeGcmComponentState(int newState, Context context) {
        Class listenerClass = IntercomPushManager.getGcmListenerClass();
        Class registrationServiceClass = IntercomPushManager.getGcmRegistrationServiceClass();
        if (registrationServiceClass != null && listenerClass != null) {
            ComponentName gcmReceiverComponent = new ComponentName(context, listenerClass);
            ComponentName gcmServiceComponent = new ComponentName(context, registrationServiceClass);
            PackageManager packageManager = context.getPackageManager();
            packageManager.setComponentEnabledSetting(gcmReceiverComponent, newState, 1);
            packageManager.setComponentEnabledSetting(gcmServiceComponent, newState, 1);
            IntercomLogger.internal("component state", "broadcast receiver is enabled: " + IntercomPushManager.isGcmComponentEnabled(gcmReceiverComponent, packageManager));
            IntercomLogger.internal("component state", "gcm service is enabled: " + IntercomPushManager.isGcmComponentEnabled(gcmServiceComponent, packageManager));
        }
    }

    private static void changeFcmComponentState(int newState, Context context) {
        Class instanceIdClass = IntercomPushManager.getFcmInstanceIdClass();
        Class messengerClass = IntercomPushManager.getFcmMessengerClass();
        if (instanceIdClass != null && messengerClass != null) {
            ComponentName fcmInstanceIdComponent = new ComponentName(context, instanceIdClass);
            ComponentName fcmMessengerComponent = new ComponentName(context, messengerClass);
            PackageManager packageManager = context.getPackageManager();
            packageManager.setComponentEnabledSetting(fcmInstanceIdComponent, newState, 1);
            packageManager.setComponentEnabledSetting(fcmMessengerComponent, newState, 1);
            IntercomLogger.internal("component state", "fcm registration service is enabled: " + IntercomPushManager.isFcmComponentEnabled(fcmInstanceIdComponent, packageManager));
            IntercomLogger.internal("component state", "fcm messaging service is enabled: " + IntercomPushManager.isFcmComponentEnabled(fcmMessengerComponent, packageManager));
        }
    }

    private static boolean isGcmComponentEnabled(ComponentName componentName, PackageManager packageManager) {
        return packageManager.getComponentEnabledSetting(componentName) == 1;
    }

    private static boolean isFcmComponentEnabled(ComponentName componentName, PackageManager packageManager) {
        return packageManager.getComponentEnabledSetting(componentName) == 1;
    }

    static IntercomPushIntegrationType getInstalledModuleType() {
        IntercomPushIntegrationType integrationType = IntercomPushIntegrationType.NONE;
        boolean fcmInstalled = IntercomPushManager.fcmModuleInstalled();
        boolean gcmInstalled = IntercomPushManager.gcmModuleInstalled();
        if (fcmInstalled && gcmInstalled) {
            integrationType = IntercomPushIntegrationType.BOTH;
        } else if (fcmInstalled) {
            integrationType = IntercomPushIntegrationType.FCM;
        } else if (gcmInstalled) {
            integrationType = IntercomPushIntegrationType.GCM;
        }
        return integrationType;
    }

    private static boolean gcmModuleInstalled() {
        return IntercomPushManager.getGcmListenerClass() != null && IntercomPushManager.getGcmRegistrationServiceClass() != null;
    }

    private static boolean fcmModuleInstalled() {
        return IntercomPushManager.getFcmMessengerClass() != null && IntercomPushManager.getFcmInstanceIdClass() != null;
    }

    @SuppressLint(value={"CommitPrefEdits"})
    static void cacheSenderId(Context context, String senderId) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        prefs.edit().putString(PREFS_SENDER_ID, senderId).commit();
    }

    public static String getSenderId(Context context) {
        SharedPreferences prefs = context.getSharedPreferences("INTERCOM_SDK_PREFS", 0);
        return prefs.getString(PREFS_SENDER_ID, "");
    }

    private static Class getGcmListenerClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.IntercomGcmListenerService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getGcmRegistrationServiceClass() {
        try {
            return Class.forName("io.intercom.android.sdk.gcm.IntercomGcmRegistrationService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getFcmMessengerClass() {
        try {
            return Class.forName("io.intercom.android.sdk.fcm.IntercomFcmMessengerService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static Class getFcmInstanceIdClass() {
        try {
            return Class.forName("io.intercom.android.sdk.fcm.IntercomFcmInstanceIDService");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static enum IntercomPushIntegrationType {
        BOTH,
        FCM,
        GCM,
        NONE;

    }
}

