/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.nexus;

import android.support.annotation.NonNull;
import android.util.LruCache;
import io.intercom.android.sdk.nexus.NexusEvent;
import io.intercom.android.sdk.nexus.NexusEventType;
import io.intercom.android.sdk.nexus.NexusListener;
import io.intercom.android.sdk.nexus.NexusLogger;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

class NexusEventPropagator
implements NexusListener {
    private final LruCache<String, Boolean> cache = new LruCache(100);
    private final List<NexusListener> listeners = new CopyOnWriteArrayList<NexusListener>();

    NexusEventPropagator() {
    }

    public void addListener(@NonNull NexusListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(@NonNull NexusListener listener) {
        this.listeners.remove(listener);
    }

    public void cacheEvent(NexusEvent event) {
        this.cache.put((Object)event.getGuid(), (Object)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notifyEvent(@NonNull NexusEvent event) {
        if (event.getEventType() != NexusEventType.UNKNOWN) {
            LruCache<String, Boolean> lruCache = this.cache;
            synchronized (lruCache) {
                if (this.cache.get((Object)event.getGuid()) == null) {
                    this.cache.put((Object)event.getGuid(), (Object)true);
                    NexusLogger.d("notifying listeners of event: " + event);
                    for (NexusListener listener : this.listeners) {
                        listener.notifyEvent(event);
                    }
                } else {
                    NexusLogger.v("dropping event, already in cache:" + event.toStringEncodedJsonObject());
                }
            }
        }
    }

    @Override
    public void onConnect() {
        NexusLogger.d("notifying listeners that a connection opened");
        for (NexusListener listener : this.listeners) {
            listener.onConnect();
        }
    }

    @Override
    public void onConnectFailed() {
        NexusLogger.d("notifying listeners that a connection failed to open");
        for (NexusListener listener : this.listeners) {
            listener.onConnectFailed();
        }
    }
}

