/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.store;

import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.UnreadConversationCountListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class UnreadCountTracker {
    @VisibleForTesting
    final List<UnreadConversationCountListener> listeners = new CopyOnWriteArrayList<UnreadConversationCountListener>();
    private Set<String> conversationIds = new HashSet<String>();

    public Set<String> getConversationIds() {
        return this.conversationIds;
    }

    public void addConversationId(String conversationId) {
        int oldCount = this.conversationIds.size();
        this.conversationIds.add(conversationId);
        if (oldCount != this.conversationIds.size()) {
            this.updateListeners(this.conversationIds.size());
        }
    }

    public void removeId(String id2) {
        int oldCount = this.conversationIds.size();
        this.conversationIds.remove(id2);
        if (oldCount != this.conversationIds.size()) {
            this.updateListeners(this.conversationIds.size());
        }
    }

    public void setConversationIds(Set<String> conversationIds) {
        int oldCount = this.conversationIds.size();
        this.conversationIds = conversationIds;
        if (oldCount != conversationIds.size()) {
            this.updateListeners(conversationIds.size());
        }
    }

    public int getCount() {
        return this.conversationIds.size();
    }

    public void addListener(@NonNull UnreadConversationCountListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(UnreadConversationCountListener listener) {
        this.listeners.remove(listener);
    }

    private void updateListeners(int newCount) {
        for (UnreadConversationCountListener listener : this.listeners) {
            listener.onCountUpdate(newCount);
        }
    }

    public void reset() {
        int oldCount = this.conversationIds.size();
        this.conversationIds.clear();
        if (oldCount != this.conversationIds.size()) {
            this.updateListeners(this.conversationIds.size());
        }
    }
}

