/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Application;
import android.app.NotificationManager;
import android.content.Context;
import android.os.Bundle;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.push.IntercomNotificationManager;
import io.intercom.android.sdk.push.IntercomPushHandler;
import io.intercom.android.sdk.utilities.ContextLocaliser;
import java.util.Map;

public class IntercomPushClient {
    private final IntercomPushHandler intercomPushHandler = new IntercomPushHandler();
    private IntercomNotificationManager intercomNotificationManager;

    public void handlePush(Application application, Bundle message) {
        Injector.init(application);
        if (this.intercomNotificationManager == null) {
            NotificationManager notificationManager = (NotificationManager)application.getSystemService("notification");
            this.intercomNotificationManager = new IntercomNotificationManager(notificationManager);
        }
        Context localisedContext = new ContextLocaliser(Injector.get().getAppIdentity()).createLocalisedContext((Context)application);
        boolean appBackgrounded = Injector.get().getLifecycleTracker().isAppBackgrounded();
        this.intercomPushHandler.handlePush(message, Injector.get().getUserIdentity(), this.intercomNotificationManager, Injector.get().getMetricsStore(), appBackgrounded, localisedContext);
    }

    public void handlePush(Application application, Map<String, String> message) {
        this.handlePush(application, this.convertMessageMapToBundle(message));
    }

    public boolean isIntercomPush(Bundle message) {
        return this.intercomPushHandler.isIntercomPush(message);
    }

    public boolean isIntercomPush(Map<String, String> message) {
        return this.isIntercomPush(this.convertMessageMapToBundle(message));
    }

    private Bundle convertMessageMapToBundle(Map<String, String> message) {
        Bundle bundle = new Bundle();
        for (Map.Entry<String, String> entry : message.entrySet()) {
            bundle.putString(entry.getKey(), entry.getValue());
        }
        return bundle;
    }
}

