/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.api;

import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.okhttp3.Interceptor;
import io.intercom.okhttp3.Response;
import java.io.IOException;

class IdentityInterceptor
implements Interceptor {
    private static final String USER_IDENTITY_CHANGED = "registered user changed while this request was in flight";
    private static final String NO_USER_IDENTITY = "no user currently registered";
    private static final String NO_APP_IDENTITY = "the apiKey or appId used to initialise Intercom are invalid";
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;

    public IdentityInterceptor(AppIdentity appIdentity, UserIdentity userIdentity) {
        this.appIdentity = appIdentity;
        this.userIdentity = userIdentity;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        if (this.userIdentity.identityExists() && this.appIdentity.identityExists()) {
            String fingerprint = this.userIdentity.getFingerprint();
            Response response = chain.proceed(chain.request());
            if (fingerprint.equals(this.userIdentity.getFingerprint())) {
                IntercomLogger.internal("interceptor", "proceeding");
                return response;
            }
            IntercomLogger.internal("interceptor", "halting: user identity changed");
            if (response != null) {
                response.body().close();
            }
            throw new IOException(USER_IDENTITY_CHANGED);
        }
        if (this.appIdentity.identityExists()) {
            throw new IOException(NO_USER_IDENTITY);
        }
        throw new IOException(NO_APP_IDENTITY);
    }
}

