/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.activities;

import android.animation.Animator;
import android.content.Context;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.design.widget.AppBarLayout;
import android.text.TextUtils;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.activities.IntercomBaseActivity;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.blocks.BlocksViewHolder;
import io.intercom.android.sdk.blocks.UploadingImageCache;
import io.intercom.android.sdk.blocks.ViewHolderGenerator;
import io.intercom.android.sdk.commons.utilities.ScreenUtils;
import io.intercom.android.sdk.conversation.ComposerInputView;
import io.intercom.android.sdk.conversation.ReactionInputView;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.Part;
import io.intercom.android.sdk.models.ReactionReply;
import io.intercom.android.sdk.utilities.BlockUtils;
import io.intercom.android.sdk.utilities.Phrase;
import io.intercom.android.sdk.utilities.SimpleAnimatorListener;
import io.intercom.android.sdk.utilities.TimeFormatter;
import io.intercom.android.sdk.views.ContentAwareScrollView;
import io.intercom.android.sdk.views.IntercomToolbar;
import io.intercom.com.facebook.rebound.BaseSpringSystem;
import io.intercom.com.facebook.rebound.SimpleSpringListener;
import io.intercom.com.facebook.rebound.Spring;
import io.intercom.com.facebook.rebound.SpringConfig;
import io.intercom.com.facebook.rebound.SpringListener;

public class IntercomPostActivity
extends IntercomBaseActivity
implements IntercomToolbar.Listener,
View.OnClickListener {
    private static final SpringConfig SPRING_CONFIG = new SpringConfig(600.0, 40.0);
    private static final String PARCEL_PART = "parcel_part";
    private static final String PARCEL_CONVERSATION_ID = "parcel_conversation_id";
    private static final String POST_PREVIEW = "is_post_preview";
    private static final String LAST_PARTICIPANT = "last_participant";
    private Part part;
    private BaseSpringSystem springSystem;
    private IntercomToolbar intercomToolbar;
    private AppBarLayout appBarLayout;
    private FrameLayout postContainer;
    private ContentAwareScrollView postView;
    private String conversationId;
    private View composerLayout;
    private ComposerInputView textComposer;
    private ReactionInputView reactionComposer;
    private LastParticipatingAdmin lastParticipatingAdmin;
    private boolean isPreview = false;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.intercom_activity_post);
        this.springSystem = Injector.get().getSpringProvider().newSpringSystem();
        this.appBarLayout = (AppBarLayout)this.findViewById(R.id.app_bar_layout);
        this.intercomToolbar = (IntercomToolbar)this.findViewById(R.id.intercom_toolbar);
        this.intercomToolbar.setListener(this);
        this.part = new Part();
        this.lastParticipatingAdmin = LastParticipatingAdmin.NULL;
        Bundle data = this.getIntent().getExtras();
        if (data != null) {
            if (data.containsKey(PARCEL_PART)) {
                this.part = (Part)data.getParcelable(PARCEL_PART);
                String teamMateName = "";
                if (this.part != null && this.part.getParticipant() != null) {
                    teamMateName = this.part.getParticipant().getForename();
                }
                String appName = Injector.get().getAppIdentity().getAppConfig().getName();
                CharSequence title = Phrase.from((Context)this, R.string.intercom_teammate_from_company).put("name", teamMateName).put("company", appName).format();
                this.intercomToolbar.setTitle(title);
            }
            if (data.containsKey(PARCEL_CONVERSATION_ID)) {
                this.conversationId = data.getString(PARCEL_CONVERSATION_ID, "");
                Injector.get().getUnreadCountTracker().removeId(this.conversationId);
                Injector.get().getApi().markConversationAsRead(this.conversationId);
            }
            if (data.containsKey(POST_PREVIEW)) {
                this.isPreview = data.getBoolean(POST_PREVIEW, false);
            }
            if (data.containsKey(LAST_PARTICIPANT)) {
                this.lastParticipatingAdmin = (LastParticipatingAdmin)data.getParcelable(LAST_PARTICIPANT);
                if (!LastParticipatingAdmin.isNull(this.lastParticipatingAdmin)) {
                    TimeFormatter timeFormatter = new TimeFormatter((Context)this, Injector.get().getTimeProvider());
                    long lastActiveTime = this.lastParticipatingAdmin.getLastActiveAt();
                    this.intercomToolbar.setSubtitle(timeFormatter.getAdminActiveStatus(lastActiveTime));
                }
            }
        }
        this.intercomToolbar.setVisibility(8);
        this.intercomToolbar.setUpPostToolbar(this.part.getParticipant().getAvatar());
        int primaryColor = Injector.get().getAppIdentity().getAppConfig().getBaseColor();
        View background = this.getWindow().getDecorView();
        background.setBackgroundColor(Color.argb((int)153, (int)Color.red((int)primaryColor), (int)Color.green((int)primaryColor), (int)Color.blue((int)primaryColor)));
        BlocksViewHolder postHolder = new ViewHolderGenerator((Context)this, new UploadingImageCache()).getPostHolder();
        this.postContainer = (FrameLayout)this.findViewById(R.id.post_container);
        this.composerLayout = this.findViewById(R.id.conversation_coordinator);
        this.textComposer = (ComposerInputView)this.findViewById(R.id.composer_input_view);
        this.reactionComposer = (ReactionInputView)this.findViewById(R.id.reaction_input_view);
        this.postView = (ContentAwareScrollView)this.findViewById(R.id.post_view);
        LinearLayout partsView = ViewHolderGenerator.createPartsLayout(postHolder, this.part, (Context)this);
        this.postView.addView(BlockUtils.getBlockView((ViewGroup)this.postView, partsView, (Context)this));
        if (this.isPreview && !ReactionReply.isNull(this.part.getReactionReply())) {
            this.postView.setListener(new ContentAwareScrollView.Listener(){

                @Override
                public void onBottomReached() {
                    IntercomPostActivity.this.postView.setListener(null);
                    if (IntercomPostActivity.this.composerLayout.getVisibility() != 0) {
                        IntercomPostActivity.this.composerLayout.setVisibility(0);
                        IntercomPostActivity.this.reactionComposer.setUpReactions(IntercomPostActivity.this.part.getReactionReply(), IntercomPostActivity.this.conversationId, IntercomPostActivity.this.part.getId(), ReactionInputView.ReactionLocation.IN_APP, true);
                    }
                }
            });
            this.reactionComposer.preloadReactionImages(this.part.getReactionReply());
        }
        if (this.openedFromConversation()) {
            Injector.get().getMetricsStore().track(MetricFactory.viewedInAppFromMessenger(this.conversationId, this.part.getId()));
        }
        background.setAlpha(0.0f);
        background.animate().alpha(1.0f).setDuration(200L).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomPostActivity.this.animateToolbar();
                IntercomPostActivity.this.animateContent();
                if (IntercomPostActivity.this.openedFromConversation()) {
                    IntercomPostActivity.this.composerLayout.setVisibility(8);
                } else if (ReactionReply.isNull(IntercomPostActivity.this.part.getReactionReply())) {
                    View touchTarget = IntercomPostActivity.this.findViewById(R.id.post_touch_target);
                    touchTarget.setOnClickListener((View.OnClickListener)IntercomPostActivity.this);
                    IntercomPostActivity.this.animateComposer();
                }
            }
        }).start();
    }

    private void animateToolbar() {
        this.springSystem.createSpring().setSpringConfig(SPRING_CONFIG).setCurrentValue((double)ScreenUtils.convertDpToPixel((float)200.0f, (Context)this)).setEndValue(0.0).addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                IntercomPostActivity.this.intercomToolbar.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomPostActivity.this.appBarLayout.setY(value);
            }
        });
    }

    private void animateContent() {
        this.springSystem.createSpring().setSpringConfig(SPRING_CONFIG).setCurrentValue((double)ScreenUtils.convertDpToPixel((float)400.0f, (Context)this)).setEndValue((double)this.getResources().getDimensionPixelSize(R.dimen.intercom_toolbar_height)).addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                IntercomPostActivity.this.postContainer.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                float value = (float)spring.getCurrentValue();
                IntercomPostActivity.this.postContainer.setY(value);
            }
        });
    }

    private void animateComposer() {
        this.springSystem.createSpring().setSpringConfig(SPRING_CONFIG).setCurrentValue((double)(-ScreenUtils.convertDpToPixel((float)156.0f, (Context)this))).setEndValue(0.0).addListener((SpringListener)new SimpleSpringListener(){

            public void onSpringActivate(Spring spring) {
                IntercomPostActivity.this.composerLayout.setVisibility(0);
                IntercomPostActivity.this.textComposer.setVisibility(0);
            }

            public void onSpringUpdate(Spring spring) {
                ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)IntercomPostActivity.this.composerLayout.getLayoutParams();
                layoutParams.bottomMargin = (int)spring.getCurrentValue();
                IntercomPostActivity.this.composerLayout.requestLayout();
            }
        });
    }

    private void closePost() {
        View background = this.getWindow().getDecorView();
        background.setAlpha(1.0f);
        background.animate().alpha(0.0f).setDuration(200L).setListener((Animator.AnimatorListener)new SimpleAnimatorListener(){

            @Override
            public void onAnimationEnd(Animator animation) {
                IntercomPostActivity.this.finish();
                IntercomPostActivity.this.overridePendingTransition(0, 0);
            }
        }).start();
    }

    public static Intent buildPostIntent(@NonNull Context context, @NonNull Part part, @NonNull String conversationId, @NonNull LastParticipatingAdmin lastParticipatingAdmin, boolean isPreview) {
        Intent intent = new Intent(context, IntercomPostActivity.class);
        intent.putExtra(PARCEL_PART, (Parcelable)part);
        if (!TextUtils.isEmpty((CharSequence)conversationId)) {
            intent.putExtra(PARCEL_CONVERSATION_ID, conversationId);
        }
        intent.putExtra(LAST_PARTICIPANT, (Parcelable)lastParticipatingAdmin);
        intent.putExtra(POST_PREVIEW, isPreview);
        intent.setFlags(0x10000000);
        return intent;
    }

    private boolean openedFromConversation() {
        return !this.isPreview;
    }

    public void onBackPressed() {
        this.closePost();
        if (this.isPreview) {
            Injector.get().getMetricsStore().track(MetricFactory.closedInAppFromFull(this.conversationId, this.part.getId()));
        }
    }

    @Override
    public void onCloseClicked() {
        this.onBackPressed();
    }

    @Override
    public void onInboxClicked() {
    }

    public void onClick(View v) {
        if (v.getId() == R.id.post_touch_target) {
            this.closePost();
            if (this.isPreview) {
                Injector.get().getMetricsStore().track(MetricFactory.openedConversationFromFull(this.conversationId, this.part.getId()));
                this.startActivity(IntercomMessengerActivity.openConversation((Context)this, this.conversationId, this.lastParticipatingAdmin));
            }
        }
    }
}

