/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Application;
import android.app.TaskStackBuilder;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import io.intercom.android.sdk.Injector;
import io.intercom.android.sdk.Intercom;
import io.intercom.android.sdk.IntercomPushManager;
import io.intercom.android.sdk.PushIntentHandler;
import io.intercom.android.sdk.R;
import io.intercom.android.sdk.UnreadConversationCountListener;
import io.intercom.android.sdk.activities.IntercomMessengerActivity;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.api.RateLimiter;
import io.intercom.android.sdk.exceptions.IntercomIntegrationException;
import io.intercom.android.sdk.identity.AppIdentity;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.models.LastParticipatingAdmin;
import io.intercom.android.sdk.models.events.CloseMessengerEvent;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.preview.LauncherOpenBehaviour;
import io.intercom.android.sdk.preview.PreviewManager;
import io.intercom.android.sdk.store.UnreadCountTracker;
import io.intercom.android.sdk.user.DeviceData;
import io.intercom.android.sdk.utilities.AttributeSanitiser;
import io.intercom.android.sdk.utilities.IntentUtils;
import io.intercom.com.squareup.otto.Bus;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RealIntercom
extends Intercom {
    private static final String RATE_LIMITED_ERROR = "Your app is being rate limited because you're performing too many requests per minute";
    private final DeDuper superDeDuper;
    private final RateLimiter rateLimiter;
    private final Api.Provider apiProvider;
    private final NexusClient nexusClient;
    private final UnreadCountTracker unreadCountTracker;
    private final MetricsStore.Provider metricsStoreProvider;
    private final Context context;
    private final PreviewManager previewManager;
    private final Bus bus;
    private final AppIdentity appIdentity;
    private final UserIdentity userIdentity;

    protected RealIntercom(Application application, String apiKey, String appId) {
        Injector.initWithAppCredentials(application, apiKey, appId);
        Injector injector = Injector.get();
        this.apiProvider = injector;
        this.nexusClient = injector.getNexusClient();
        this.unreadCountTracker = injector.getUnreadCountTracker();
        this.metricsStoreProvider = injector;
        this.superDeDuper = injector.getDeDuper();
        this.context = injector.getApplication();
        this.previewManager = injector.getPreviewManager();
        this.bus = injector.getBus();
        this.appIdentity = injector.getAppIdentity();
        this.userIdentity = injector.getUserIdentity();
        this.rateLimiter = new RateLimiter(this.appIdentity.getAppConfig());
        switch (IntercomPushManager.getInstalledModuleType()) {
            case BOTH: {
                throw new IntercomIntegrationException("Both Intercom FCM and GCM modules were included. Please include only one of these dependencies in your project.");
            }
            case FCM: {
                IntercomLogger.i("Enabling FCM for cloud messaging");
                IntercomPushManager.changeComponentState(1, (Context)application);
                break;
            }
            case GCM: {
                IntercomLogger.i("Enabling GCM for cloud messaging");
                IntercomPushManager.changeComponentState(1, (Context)application);
                this.setGcmSenderId();
                IntercomPushManager.startGcmRegistrationService(this.context);
                break;
            }
            default: {
                IntercomLogger.internal("No push integration detected");
            }
        }
    }

    private void setGcmSenderId() {
        String senderId = this.context.getString(R.string.intercom_gcm_sender_id);
        if (!TextUtils.isEmpty((CharSequence)senderId)) {
            IntercomPushManager.cacheSenderId(this.context, senderId);
        }
    }

    @Override
    public void registerUnidentifiedUser() {
        if (this.userIdentity.canRegisterUnidentifiedUser()) {
            this.userIdentity.registerUnidentifiedUser();
            this.apiProvider.getApi().registerUnidentifiedUser();
        } else {
            IntercomLogger.i("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this. If you are attempting to register an identified user call: registerIdentifiedUser(Registration)");
        }
    }

    @Override
    public void registerIdentifiedUser(Registration userRegistration) {
        if (userRegistration != null) {
            if (this.userIdentity.canRegisterIdentifiedUser(userRegistration)) {
                this.userIdentity.registerIdentifiedUser(userRegistration);
                this.apiProvider.getApi().registerIdentifiedUser(userRegistration);
            } else if (this.userIdentity.registrationHasAttributes(userRegistration)) {
                IntercomLogger.i("We already have a registered user. Updating this user with the attributes provided.");
                this.updateUser(userRegistration.getAttributes());
            } else {
                IntercomLogger.i("Failed to register user. We already have a registered user. If you are attempting to register a new user, call reset before this.");
            }
        } else {
            IntercomLogger.e("The registration object you passed to is null. An example successful call is registerIdentifiedUser(new Registration().withEmail(email));");
        }
    }

    @Override
    public void setSecureMode(String secureHash, String secureData) {
        if (TextUtils.isEmpty((CharSequence)secureHash)) {
            IntercomLogger.w("The HMAC you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without a valid HMAC.");
        } else if (TextUtils.isEmpty((CharSequence)secureData)) {
            IntercomLogger.w("The data you sent us for secure mode was either null or empty, we will not be able to authenticate your requests without valid data.");
        } else {
            this.userIdentity.setSecureMode(secureHash, secureData);
        }
    }

    @Override
    public void updateUser(Map<String, ?> attributes) {
        if (attributes == null) {
            IntercomLogger.e("updateUser method failed: the attributes Map provided is null");
        } else if (attributes.isEmpty()) {
            IntercomLogger.e("updateUser method failed: the attributes Map provided is empty");
        } else if (this.rateLimiter.isLimited()) {
            IntercomLogger.e(RATE_LIMITED_ERROR);
        } else {
            HashMap userAttributes = new HashMap(attributes);
            this.rateLimiter.increment();
            if (this.userIdentity.isUnidentified()) {
                AttributeSanitiser.anonymousSanitisation(userAttributes);
            }
            if (this.superDeDuper.shouldUpdateUser(userAttributes)) {
                this.superDeDuper.setAttributes(userAttributes);
                this.apiProvider.getApi().updateUser(userAttributes);
                IntercomLogger.internal("dupe", "updated user");
            } else {
                IntercomLogger.internal("dupe", "dropped dupe");
            }
        }
    }

    @Override
    public void logEvent(String name) {
        this.logEventWithValidation(name, new HashMap());
    }

    @Override
    public void logEvent(String name, Map<String, ?> metadata) {
        if (metadata == null) {
            IntercomLogger.i("The metadata provided is null, logging event with no metadata");
            metadata = new HashMap();
        } else if (!metadata.isEmpty()) {
            IntercomLogger.i("The metadata provided is empty, logging event with no metadata");
        }
        this.logEventWithValidation(name, metadata);
    }

    private void logEventWithValidation(String name, Map<String, ?> metadata) {
        if (TextUtils.isEmpty((CharSequence)name)) {
            IntercomLogger.e("The event name is null or empty. We can't log an event with this string.");
        } else if (this.rateLimiter.isLimited()) {
            IntercomLogger.e(RATE_LIMITED_ERROR);
        } else {
            this.rateLimiter.increment();
            this.apiProvider.getApi().logEvent(name, metadata);
        }
    }

    @Override
    public void displayMessenger() {
        Injector injector = Injector.get();
        new LauncherOpenBehaviour(injector.getAppIdentity(), injector.getUnreadCountTracker(), injector.getHasConversationsStore(), injector.getLastViewStore(), LauncherOpenBehaviour.LauncherType.CUSTOM, this.metricsStoreProvider).openMessenger(this.context);
    }

    @Override
    public void displayMessageComposer() {
        if (this.appIdentity.getAppConfig().isInboundMessages()) {
            this.metricsStoreProvider.getMetricsStore().track(MetricFactory.openedMessengerNewConversation(LauncherOpenBehaviour.LauncherType.CUSTOM));
            this.context.startActivity(IntercomMessengerActivity.openComposer(this.context));
        } else {
            IntercomLogger.e("It appears your app is not on a plan that allows message composing. As a fallback we are calling displayConversationsList()");
            this.displayConversationsList();
        }
    }

    @Override
    public void displayConversationsList() {
        this.metricsStoreProvider.getMetricsStore().track(MetricFactory.openedMessengerConversationList(LauncherOpenBehaviour.LauncherType.CUSTOM));
        this.context.startActivity(IntercomMessengerActivity.openInbox(this.context));
    }

    @Override
    public void setInAppMessageVisibility(Intercom.Visibility visibility) {
        this.previewManager.setPreviewVisibility(visibility);
    }

    @Override
    public void setLauncherVisibility(Intercom.Visibility visibility) {
        this.previewManager.setLauncherVisibility(visibility);
    }

    @Override
    public void hideMessenger() {
        this.bus.post((Object)new CloseMessengerEvent());
    }

    @Override
    public void openGcmMessage() {
        this.handlePushMessage();
    }

    @Override
    public void openGcmMessage(TaskStackBuilder customStack) {
        this.handlePushMessage(customStack);
    }

    @Override
    public void handlePushMessage() {
        this.handlePushMessage(null);
    }

    @Override
    public void handlePushMessage(TaskStackBuilder customStack) {
        PushIntentHandler pushIntentHandler = Injector.get().getPushIntentHandler();
        if (pushIntentHandler.isEmpty()) {
            IntercomLogger.internal("No Uri found");
        } else {
            Uri pushData = pushIntentHandler.getLastPushData();
            String pushOnlyId = pushIntentHandler.getLastPushOnlyId();
            if (pushIntentHandler.hasPushOnlyId()) {
                this.apiProvider.getApi().markConversationAsRead(pushOnlyId);
                this.openPushOnlyMessage(pushOnlyId, pushData.toString(), this.context);
            } else {
                this.openIntercomChatPush(pushData.getPathSegments(), customStack);
            }
            pushIntentHandler.clear();
        }
    }

    private void openPushOnlyMessage(String conversationId, String pushOnlyData, Context context) {
        Intent notificationIntent = new Intent("android.intent.action.VIEW", Uri.parse((String)pushOnlyData));
        notificationIntent.addFlags(0x10000000);
        if (notificationIntent.resolveActivity(context.getPackageManager()) != null) {
            this.metricsStoreProvider.getMetricsStore().track(MetricFactory.openedPushOnlyNotification(conversationId));
            IntentUtils.safelyOpenIntent(context, notificationIntent);
        } else {
            IntercomLogger.i("This device has no application that can handlethe Uri passed in");
        }
    }

    private void openIntercomChatPush(List<String> pathParts, TaskStackBuilder customStack) {
        String conversationId;
        Intent messengerIntent;
        String firstPart = pathParts.get(1);
        if (firstPart.equals("multiple_notifications")) {
            messengerIntent = IntercomMessengerActivity.openInbox(this.context);
            conversationId = "multiple_notifications";
        } else {
            conversationId = firstPart.substring(firstPart.lastIndexOf(61) + 1);
            messengerIntent = IntercomMessengerActivity.openConversation(this.context, conversationId, LastParticipatingAdmin.NULL);
        }
        if (customStack != null && Build.VERSION.SDK_INT >= 16) {
            customStack.addNextIntent(messengerIntent);
            this.context.startActivities(customStack.getIntents());
        } else {
            this.context.startActivity(messengerIntent);
        }
        this.metricsStoreProvider.getMetricsStore().track(MetricFactory.viewedPushNotification(conversationId));
        IntercomPushManager.clearNotifications(this.context);
    }

    @Override
    public void reset() {
        String deviceToken = DeviceData.getPushToken(this.context);
        if (TextUtils.isEmpty((CharSequence)deviceToken)) {
            IntercomLogger.i("There is no device token to remove.");
        } else {
            this.apiProvider.getApi().removeGcmDeviceToken(deviceToken);
        }
        this.appIdentity.getAppConfig().resetRealTimeConfig();
        this.nexusClient.disconnect();
        this.userIdentity.reset();
        this.bus.post((Object)new CloseMessengerEvent());
        this.previewManager.reset();
        this.unreadCountTracker.reset();
        Injector injector = Injector.get();
        injector.getHasConversationsStore().reset();
        injector.getLastViewStore().reset();
        IntercomLogger.i("Successfully reset user. To resume communicating with Intercom, you can register a user");
    }

    @Override
    public int getUnreadConversationCount() {
        return this.unreadCountTracker.getCount();
    }

    @Override
    public void addUnreadConversationCountListener(@NonNull UnreadConversationCountListener listener) {
        if (listener != null) {
            this.unreadCountTracker.addListener(listener);
            listener.onCountUpdate(this.unreadCountTracker.getCount());
        }
    }

    @Override
    public void removeUnreadConversationCountListener(UnreadConversationCountListener listener) {
        this.unreadCountTracker.removeListener(listener);
    }
}

