/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.IntercomPushManager;
import io.intercom.android.sdk.PushIntentHandler;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.api.DeDuper;
import io.intercom.android.sdk.identity.AppConfig;
import io.intercom.android.sdk.logger.IntercomLogger;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.nexus.NexusClient;
import io.intercom.android.sdk.utilities.TimeProvider;
import java.util.HashSet;
import java.util.Set;

public class IntercomLifecycleTracker
implements Application.ActivityLifecycleCallbacks {
    private static final int SESSION_TIMEOUT = 20000;
    private final Set<String> attachedActivities = new HashSet<String>();
    private final MetricsStore.Provider metricsStoreProvider;
    private final PushIntentHandler pushIntentHandler;
    private final DeDuper deDuper;
    private final Api.Provider apiProvider;
    private final AppConfig.Provider appConfigProvider;
    private final NexusClient nexusClient;
    private final TimeProvider timeProvider;
    private long enteredBackgroundAt = 0L;
    private boolean backgrounded = true;

    IntercomLifecycleTracker(Api.Provider apiProvider, DeDuper deDuper, MetricsStore.Provider metricsStoreProvider, PushIntentHandler pushIntentHandler, NexusClient nexusClient, AppConfig.Provider appConfigProvider, TimeProvider timeProvider) {
        this.deDuper = deDuper;
        this.apiProvider = apiProvider;
        this.metricsStoreProvider = metricsStoreProvider;
        this.pushIntentHandler = pushIntentHandler;
        this.nexusClient = nexusClient;
        this.appConfigProvider = appConfigProvider;
        this.timeProvider = timeProvider;
    }

    public boolean isAppBackgrounded() {
        return this.backgrounded;
    }

    private static boolean isScreenLocked(Context context) {
        KeyguardManager keyguardManager = (KeyguardManager)context.getSystemService("keyguard");
        return keyguardManager.inKeyguardRestrictedInputMode();
    }

    private void attachActivity(Activity activity) {
        this.attachedActivities.add(activity.getClass().getName());
    }

    private void detachActivity(Activity activity) {
        this.attachedActivities.remove(activity.getClass().getName());
    }

    @VisibleForTesting
    boolean isApplicationInBackground(Activity activity) {
        return IntercomLifecycleTracker.isScreenLocked((Context)activity) || this.attachedActivities.isEmpty() && !activity.isChangingConfigurations();
    }

    @VisibleForTesting
    boolean hasApplicationBecomeBackgrounded(Activity activity) {
        return this.isApplicationInBackground(activity) && !this.backgrounded;
    }

    private void appEnteredBackground() {
        this.backgrounded = true;
        IntercomLogger.internal("lifecycles", "backgrounded");
        this.nexusClient.disconnect();
        this.enteredBackgroundAt = this.timeProvider.currentTimeMillis();
        this.deDuper.reset();
        this.metricsStoreProvider.getMetricsStore().sendMetrics();
    }

    private void appEnteredForeground(@NonNull Intent intent) {
        this.backgrounded = false;
        IntercomLogger.internal("lifecycles", "foregrounded");
        if (this.timeProvider.currentTimeMillis() - this.enteredBackgroundAt > 20000L) {
            this.apiProvider.getApi().ping();
            IntercomLogger.internal("sdk ping", "backgrounded ping from lifecycles");
        }
        this.updatePushIntent(intent);
    }

    private void updatePushIntent(@NonNull Intent intent) {
        if (IntercomPushManager.getInstalledModuleType() != IntercomPushManager.IntercomPushIntegrationType.NONE) {
            this.pushIntentHandler.updateLastStoredIntent(intent);
        }
    }

    public void onActivityCreated(Activity activity, Bundle bundle) {
        IntercomLogger.internal("lifecycles", "on create");
        this.updatePushIntent(activity.getIntent());
    }

    public void onActivityStarted(Activity activity) {
        IntercomLogger.internal("lifecycles", "on start");
        this.attachActivity(activity);
        if (this.backgrounded) {
            this.appEnteredForeground(activity.getIntent());
        }
        IntercomPushManager.clearNotifications((Context)activity);
        this.nexusClient.connect(this.appConfigProvider.getAppConfig().getRealTimeConfig(), true);
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle bundle) {
    }

    public void onActivityResumed(Activity activity) {
        IntercomLogger.internal("lifecycles", "on resume");
    }

    public void onActivityPaused(Activity activity) {
        IntercomLogger.internal("lifecycles", "on pause");
    }

    public void onActivityStopped(Activity activity) {
        IntercomLogger.internal("lifecycles", "on stop");
        this.detachActivity(activity);
        if (this.hasApplicationBecomeBackgrounded(activity)) {
            this.appEnteredBackground();
        }
    }

    public void onActivityDestroyed(Activity activity) {
        IntercomLogger.internal("lifecycles", "on destroy");
    }
}

