/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.app.Notification;
import android.app.NotificationManager;
import android.content.Context;
import android.support.annotation.VisibleForTesting;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.push.PushPayload;
import io.intercom.android.sdk.push.SystemNotificationFactory;
import io.intercom.android.sdk.twig.Twig;
import java.util.ArrayList;
import java.util.List;

public class SystemNotificationManager {
    private static final int NOTIFICATION_ID = 9999997;
    @VisibleForTesting
    final List<PushPayload> receivedPayloads = new ArrayList<PushPayload>();
    private final Twig twig = TwigFactory.getLogger();
    private final SystemNotificationFactory systemNotificationFactory;
    private final NotificationManager androidNotificationManager;

    public SystemNotificationManager(NotificationManager androidNotificationManager) {
        this(androidNotificationManager, new SystemNotificationFactory());
    }

    @VisibleForTesting
    SystemNotificationManager(NotificationManager androidNotificationManager, SystemNotificationFactory systemNotificationFactory) {
        this.androidNotificationManager = androidNotificationManager;
        this.systemNotificationFactory = systemNotificationFactory;
    }

    public void clear() {
        if (!this.receivedPayloads.isEmpty()) {
            this.twig.i("Removing Intercom push notifications.", new Object[0]);
        }
        this.androidNotificationManager.cancel(9999997);
        this.receivedPayloads.clear();
    }

    void createPushOnlyNotification(PushPayload payload, Context context) {
        Notification notification = this.systemNotificationFactory.createPushOnlyNotification(payload, context);
        String pushOnlyConversationId = payload.getPushOnlyConversationId();
        this.androidNotificationManager.notify(pushOnlyConversationId, pushOnlyConversationId.hashCode(), notification);
    }

    void createNotification(PushPayload payload, Context context) {
        for (PushPayload current : this.receivedPayloads) {
            if (!current.equals(payload)) continue;
            return;
        }
        this.receivedPayloads.add(payload);
        Notification notification = this.receivedPayloads.size() == 1 ? this.systemNotificationFactory.createSingleNotification(payload, context) : this.systemNotificationFactory.createGroupedNotification(this.receivedPayloads, context);
        this.androidNotificationManager.notify(9999997, notification);
    }
}

