/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.identity;

import android.text.TextUtils;
import io.intercom.android.sdk.identity.Registration;
import io.intercom.android.sdk.identity.UserIdentity;

class SoftUserIdentity {
    private String data = "";
    private String hmac = "";
    private String anonymousId = "";
    private String intercomId = "";
    private String userId = "";
    private String email = "";
    private String fingerprint = "";

    SoftUserIdentity() {
    }

    void storeUserIdentityValues(UserIdentity userIdentity) {
        this.userId = userIdentity.getUserId();
        this.email = userIdentity.getEmail();
        this.anonymousId = userIdentity.getAnonymousId();
        this.intercomId = userIdentity.getIntercomId();
        this.data = userIdentity.getData();
        this.hmac = userIdentity.getHmac();
        this.fingerprint = userIdentity.getFingerprint();
    }

    boolean isSameUser(Registration userRegistration) {
        boolean matches;
        String registrationId = userRegistration.getUserId();
        String registrationEmail = userRegistration.getEmail();
        boolean bl = matches = !TextUtils.isEmpty((CharSequence)registrationId) || !TextUtils.isEmpty((CharSequence)registrationEmail);
        if (!TextUtils.isEmpty((CharSequence)registrationId)) {
            boolean bl2 = matches = matches && registrationId.equals(this.userId);
        }
        if (!TextUtils.isEmpty((CharSequence)registrationEmail)) {
            matches = matches && registrationEmail.equals(this.email);
        }
        return matches;
    }

    void clear() {
        this.data = "";
        this.hmac = "";
        this.anonymousId = "";
        this.intercomId = "";
        this.userId = "";
        this.email = "";
        this.fingerprint = "";
    }

    boolean isEmpty() {
        return TextUtils.isEmpty((CharSequence)this.email) && TextUtils.isEmpty((CharSequence)this.userId) && TextUtils.isEmpty((CharSequence)this.intercomId) && TextUtils.isEmpty((CharSequence)this.anonymousId) && TextUtils.isEmpty((CharSequence)this.hmac) && TextUtils.isEmpty((CharSequence)this.data) && TextUtils.isEmpty((CharSequence)this.fingerprint);
    }

    String getData() {
        return this.data;
    }

    String getHmac() {
        return this.hmac;
    }

    String getAnonymousId() {
        return this.anonymousId;
    }

    String getIntercomId() {
        return this.intercomId;
    }

    String getUserId() {
        return this.userId;
    }

    String getEmail() {
        return this.email;
    }

    String getFingerprint() {
        return this.fingerprint;
    }
}

