/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import io.intercom.android.sdk.Company;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class User {
    private static final String EMAIL = "email";
    private static final String USER_ID = "user_id";
    private static final String NAME = "name";
    private static final String CUSTOM_ATTRIBUTES = "custom_attributes";
    private static final String COMPANIES = "companies";
    private static final String CREATED_AT = "created_at";
    private static final String UNSUBSCRIBED_FROM_EMAILS = "unsubscribed_from_emails";
    private final Map<String, Object> attributes;
    private final Map<String, Object> customAttributes;
    private final List<Map<String, Object>> companies;

    User(Builder builder) {
        this.attributes = builder.attributes;
        this.customAttributes = builder.customAttributes;
        this.companies = builder.companies;
    }

    Map<String, Object> getAttributes() {
        if (!this.customAttributes.isEmpty()) {
            this.attributes.put(CUSTOM_ATTRIBUTES, this.customAttributes);
        }
        if (!this.companies.isEmpty()) {
            this.attributes.put(COMPANIES, this.companies);
        }
        return this.attributes;
    }

    public static final class Builder {
        final Map<String, Object> attributes = new HashMap<String, Object>();
        final Map<String, Object> customAttributes = new HashMap<String, Object>();
        final List<Map<String, Object>> companies = new ArrayList<Map<String, Object>>();

        public User build() {
            return new User(this);
        }

        public Builder withEmail(@Nullable String email) {
            this.attributes.put(User.EMAIL, email);
            return this;
        }

        public Builder withUserId(@Nullable String userId) {
            this.attributes.put(User.USER_ID, userId);
            return this;
        }

        public Builder withName(@Nullable String name) {
            this.attributes.put(User.NAME, name);
            return this;
        }

        public Builder withCreatedAt(@Nullable Long createdAt) {
            this.attributes.put(User.CREATED_AT, createdAt);
            return this;
        }

        public Builder withUnsubscribedFromEmails(@Nullable Boolean unsubscribedFromEmails) {
            this.attributes.put(User.UNSUBSCRIBED_FROM_EMAILS, unsubscribedFromEmails);
            return this;
        }

        public Builder withCompany(@NonNull Company company) {
            this.companies.add(company.getAttributes());
            return this;
        }

        public Builder withCustomAttribute(@NonNull String key, @Nullable Object attribute) {
            this.customAttributes.put(key, attribute);
            return this;
        }

        public Builder withCustomAttributes(@NonNull Map<String, ?> attributes) {
            this.customAttributes.putAll(attributes);
            return this;
        }
    }
}

