/*
 * Decompiled with CFR 0.152.
 */
package io.intercom.android.sdk.push;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import io.intercom.android.sdk.api.Api;
import io.intercom.android.sdk.identity.UserIdentity;
import io.intercom.android.sdk.logger.TwigFactory;
import io.intercom.android.sdk.metrics.MetricFactory;
import io.intercom.android.sdk.metrics.MetricsStore;
import io.intercom.android.sdk.push.PushBroadcast;
import io.intercom.android.sdk.twig.Twig;
import io.intercom.android.sdk.utilities.IntentUtils;
import java.util.List;

class PushReceiverDelegate {
    private static final String CONSUMED_BY_INTERCOM = "consumed_by_intercom";
    private final Twig twig = TwigFactory.getLogger();

    PushReceiverDelegate() {
    }

    void handlePushTap(Context context, Intent intent, Api api, UserIdentity userIdentity, MetricsStore metricsStore, MetricFactory metricFactory) {
        if (userIdentity.identityExists()) {
            Intent hostAppIntent = (Intent)intent.getParcelableExtra("host_app_intent");
            if (hostAppIntent == null) {
                return;
            }
            PushBroadcast openedPush = this.createPushFromIntent(hostAppIntent);
            if (openedPush.isEmpty()) {
                this.twig.internal("Could not open push. No Uri and conversation id found.");
            } else {
                Uri pushData = openedPush.getPushData();
                String pushOnlyId = openedPush.getPushOnlyId();
                if (openedPush.hasPushOnlyId()) {
                    this.handlePushMessage(context, api, pushData, pushOnlyId, metricsStore, metricFactory);
                } else {
                    this.openHostAppIntent(context, hostAppIntent, this.extractNotificationId(pushData));
                }
            }
        }
    }

    private void handlePushMessage(Context context, Api api, Uri destinationUri, String pushOnlyId, MetricsStore metricsStore, MetricFactory metricFactory) {
        Intent notificationIntent;
        api.markConversationAsRead(pushOnlyId);
        if (Uri.EMPTY.equals((Object)destinationUri)) {
            this.twig.i("There was no URI in the push message. Defaulting to launch activity", new Object[0]);
            notificationIntent = this.getLaunchActivityIntent(context);
        } else {
            notificationIntent = new Intent("android.intent.action.VIEW", destinationUri);
        }
        notificationIntent.addFlags(0x10000000);
        metricsStore.track(metricFactory.openedPushOnlyNotification(pushOnlyId));
        IntentUtils.safelyOpenIntent(context, notificationIntent);
    }

    private Intent getLaunchActivityIntent(Context context) {
        Intent launchIntent;
        PackageManager packageManager = context.getPackageManager();
        try {
            launchIntent = packageManager.getLaunchIntentForPackage(context.getPackageName());
            if (launchIntent == null) {
                throw new PackageManager.NameNotFoundException();
            }
            launchIntent.addCategory("android.intent.category.LAUNCHER");
        }
        catch (PackageManager.NameNotFoundException e) {
            launchIntent = new Intent();
        }
        return launchIntent;
    }

    private void openHostAppIntent(Context context, Intent hostAppIntent, String pushData) {
        context.getSharedPreferences("INTERCOM_SDK_PUSH_PREFS", 0).edit().putString("intercom_push_notification_path", pushData).apply();
        IntentUtils.safelyOpenIntent(context, hostAppIntent);
    }

    private PushBroadcast createPushFromIntent(Intent intent) {
        PushBroadcast storedPush = new PushBroadcast();
        if (intent == null) {
            this.twig.internal("Host app intent was null.");
            return storedPush;
        }
        if (this.notLaunchedFromHistory(intent) && this.notConsumedByIntercom(intent) && this.isIntercomIntent(intent.getExtras())) {
            storedPush = new PushBroadcast(intent);
            intent.putExtra(CONSUMED_BY_INTERCOM, true);
        }
        return storedPush;
    }

    private String extractNotificationId(Uri pushData) {
        List pathParts = pushData.getPathSegments();
        if (pathParts.isEmpty()) {
            return "";
        }
        String firstPart = (String)pathParts.get(1);
        if (firstPart.equals("multiple_notifications")) {
            return "multiple_notifications";
        }
        return firstPart.substring(firstPart.lastIndexOf(61) + 1);
    }

    void trackDismiss(Intent intent, UserIdentity userIdentity, MetricsStore metricsStore, MetricFactory metricFactory) {
        if (userIdentity.identityExists()) {
            Intent hostAppIntent = (Intent)intent.getParcelableExtra("host_app_intent");
            if (hostAppIntent == null) {
                return;
            }
            PushBroadcast dismissedPush = new PushBroadcast(hostAppIntent);
            if (dismissedPush.isEmpty()) {
                this.twig.internal("Could not track push dismiss. No Uri found");
            } else {
                boolean isPushOnly = dismissedPush.hasPushOnlyId();
                String conversationId = isPushOnly ? dismissedPush.getPushOnlyId() : this.extractNotificationId(dismissedPush.getPushData());
                metricsStore.track(metricFactory.dismissedPushNotification(conversationId, isPushOnly));
            }
        }
    }

    private boolean notConsumedByIntercom(Intent intent) {
        return !intent.getBooleanExtra(CONSUMED_BY_INTERCOM, false);
    }

    private boolean isIntercomIntent(Bundle intentExtras) {
        return intentExtras != null && intentExtras.containsKey("intercom_push_key");
    }

    private boolean notLaunchedFromHistory(Intent intent) {
        return (intent.getFlags() & 0x100000) == 0;
    }
}

